/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for inference parameters when using AI Prompts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIPromptInferenceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AIPromptInferenceConfiguration.Builder, AIPromptInferenceConfiguration> {
    private static final SdkField<TextAIPromptInferenceConfiguration> TEXT_AI_PROMPT_INFERENCE_CONFIGURATION_FIELD = SdkField
            .<TextAIPromptInferenceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("textAIPromptInferenceConfiguration")
            .getter(getter(AIPromptInferenceConfiguration::textAIPromptInferenceConfiguration))
            .setter(setter(Builder::textAIPromptInferenceConfiguration))
            .constructor(TextAIPromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textAIPromptInferenceConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEXT_AI_PROMPT_INFERENCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextAIPromptInferenceConfiguration textAIPromptInferenceConfiguration;

    private final Type type;

    private AIPromptInferenceConfiguration(BuilderImpl builder) {
        this.textAIPromptInferenceConfiguration = builder.textAIPromptInferenceConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The inference configuration for text-based AI Prompts.
     * </p>
     * 
     * @return The inference configuration for text-based AI Prompts.
     */
    public final TextAIPromptInferenceConfiguration textAIPromptInferenceConfiguration() {
        return textAIPromptInferenceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textAIPromptInferenceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIPromptInferenceConfiguration)) {
            return false;
        }
        AIPromptInferenceConfiguration other = (AIPromptInferenceConfiguration) obj;
        return Objects.equals(textAIPromptInferenceConfiguration(), other.textAIPromptInferenceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIPromptInferenceConfiguration")
                .add("TextAIPromptInferenceConfiguration", textAIPromptInferenceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textAIPromptInferenceConfiguration":
            return Optional.ofNullable(clazz.cast(textAIPromptInferenceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #textAIPromptInferenceConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * The inference configuration for text-based AI Prompts.
     * </p>
     * 
     * @param textAIPromptInferenceConfiguration
     *        The inference configuration for text-based AI Prompts.
     */
    public static AIPromptInferenceConfiguration fromTextAIPromptInferenceConfiguration(
            TextAIPromptInferenceConfiguration textAIPromptInferenceConfiguration) {
        return builder().textAIPromptInferenceConfiguration(textAIPromptInferenceConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #textAIPromptInferenceConfiguration()} initialized to the given
     * value.
     *
     * <p>
     * The inference configuration for text-based AI Prompts.
     * </p>
     * 
     * @param textAIPromptInferenceConfiguration
     *        The inference configuration for text-based AI Prompts.
     */
    public static AIPromptInferenceConfiguration fromTextAIPromptInferenceConfiguration(
            Consumer<TextAIPromptInferenceConfiguration.Builder> textAIPromptInferenceConfiguration) {
        TextAIPromptInferenceConfiguration.Builder builder = TextAIPromptInferenceConfiguration.builder();
        textAIPromptInferenceConfiguration.accept(builder);
        return fromTextAIPromptInferenceConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textAIPromptInferenceConfiguration", TEXT_AI_PROMPT_INFERENCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIPromptInferenceConfiguration, T> g) {
        return obj -> g.apply((AIPromptInferenceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIPromptInferenceConfiguration> {
        /**
         * <p>
         * The inference configuration for text-based AI Prompts.
         * </p>
         * 
         * @param textAIPromptInferenceConfiguration
         *        The inference configuration for text-based AI Prompts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textAIPromptInferenceConfiguration(TextAIPromptInferenceConfiguration textAIPromptInferenceConfiguration);

        /**
         * <p>
         * The inference configuration for text-based AI Prompts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TextAIPromptInferenceConfiguration.Builder} avoiding the need to create one manually via
         * {@link TextAIPromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextAIPromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #textAIPromptInferenceConfiguration(TextAIPromptInferenceConfiguration)}.
         * 
         * @param textAIPromptInferenceConfiguration
         *        a consumer that will call methods on {@link TextAIPromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textAIPromptInferenceConfiguration(TextAIPromptInferenceConfiguration)
         */
        default Builder textAIPromptInferenceConfiguration(
                Consumer<TextAIPromptInferenceConfiguration.Builder> textAIPromptInferenceConfiguration) {
            return textAIPromptInferenceConfiguration(TextAIPromptInferenceConfiguration.builder()
                    .applyMutation(textAIPromptInferenceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextAIPromptInferenceConfiguration textAIPromptInferenceConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AIPromptInferenceConfiguration model) {
            textAIPromptInferenceConfiguration(model.textAIPromptInferenceConfiguration);
        }

        public final TextAIPromptInferenceConfiguration.Builder getTextAIPromptInferenceConfiguration() {
            return textAIPromptInferenceConfiguration != null ? textAIPromptInferenceConfiguration.toBuilder() : null;
        }

        public final void setTextAIPromptInferenceConfiguration(
                TextAIPromptInferenceConfiguration.BuilderImpl textAIPromptInferenceConfiguration) {
            Object oldValue = this.textAIPromptInferenceConfiguration;
            this.textAIPromptInferenceConfiguration = textAIPromptInferenceConfiguration != null ? textAIPromptInferenceConfiguration
                    .build() : null;
            handleUnionValueChange(Type.TEXT_AI_PROMPT_INFERENCE_CONFIGURATION, oldValue, this.textAIPromptInferenceConfiguration);
        }

        @Override
        public final Builder textAIPromptInferenceConfiguration(
                TextAIPromptInferenceConfiguration textAIPromptInferenceConfiguration) {
            Object oldValue = this.textAIPromptInferenceConfiguration;
            this.textAIPromptInferenceConfiguration = textAIPromptInferenceConfiguration;
            handleUnionValueChange(Type.TEXT_AI_PROMPT_INFERENCE_CONFIGURATION, oldValue, this.textAIPromptInferenceConfiguration);
            return this;
        }

        @Override
        public AIPromptInferenceConfiguration build() {
            return new AIPromptInferenceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AIPromptInferenceConfiguration#type()
     */
    public enum Type {
        TEXT_AI_PROMPT_INFERENCE_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
