/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The assessment information from the AI Guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIGuardrailAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<AIGuardrailAssessment.Builder, AIGuardrailAssessment> {
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("blocked").getter(getter(AIGuardrailAssessment::blocked)).setter(setter(Builder::blocked))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean blocked;

    private AIGuardrailAssessment(BuilderImpl builder) {
        this.blocked = builder.blocked;
    }

    /**
     * <p>
     * Indicates whether the AI Guardrail blocked the content.
     * </p>
     * 
     * @return Indicates whether the AI Guardrail blocked the content.
     */
    public final Boolean blocked() {
        return blocked;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blocked());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailAssessment)) {
            return false;
        }
        AIGuardrailAssessment other = (AIGuardrailAssessment) obj;
        return Objects.equals(blocked(), other.blocked());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIGuardrailAssessment").add("Blocked", blocked()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blocked":
            return Optional.ofNullable(clazz.cast(blocked()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blocked", BLOCKED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailAssessment, T> g) {
        return obj -> g.apply((AIGuardrailAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIGuardrailAssessment> {
        /**
         * <p>
         * Indicates whether the AI Guardrail blocked the content.
         * </p>
         * 
         * @param blocked
         *        Indicates whether the AI Guardrail blocked the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blocked(Boolean blocked);
    }

    static final class BuilderImpl implements Builder {
        private Boolean blocked;

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailAssessment model) {
            blocked(model.blocked);
        }

        public final Boolean getBlocked() {
            return blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        @Override
        public AIGuardrailAssessment build() {
            return new AIGuardrailAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
