/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.RuntimeSessionData;
import software.amazon.awssdk.services.qconnect.model.RuntimeSessionDataListCopier;
import software.amazon.awssdk.services.qconnect.model.SessionDataNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSessionDataRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateSessionDataRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateSessionDataRequest.getter(UpdateSessionDataRequest::assistantId)).setter(UpdateSessionDataRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<List<RuntimeSessionData>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("data").getter(UpdateSessionDataRequest.getter(UpdateSessionDataRequest::data)).setter(UpdateSessionDataRequest.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuntimeSessionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(UpdateSessionDataRequest.getter(UpdateSessionDataRequest::namespaceAsString)).setter(UpdateSessionDataRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(UpdateSessionDataRequest.getter(UpdateSessionDataRequest::sessionId)).setter(UpdateSessionDataRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, DATA_FIELD, NAMESPACE_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assistantId", ASSISTANT_ID_FIELD);
            this.put("data", DATA_FIELD);
            this.put("namespace", NAMESPACE_FIELD);
            this.put("sessionId", SESSION_ID_FIELD);
        }
    });
    private final String assistantId;
    private final List<RuntimeSessionData> data;
    private final String namespace;
    private final String sessionId;

    private UpdateSessionDataRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.data = builder.data;
        this.namespace = builder.namespace;
        this.sessionId = builder.sessionId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructList);
    }

    public final List<RuntimeSessionData> data() {
        return this.data;
    }

    public final SessionDataNamespace namespace() {
        return SessionDataNamespace.fromValue(this.namespace);
    }

    public final String namespaceAsString() {
        return this.namespace;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionDataRequest)) {
            return false;
        }
        UpdateSessionDataRequest other = (UpdateSessionDataRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && Objects.equals(this.namespaceAsString(), other.namespaceAsString()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSessionDataRequest").add("AssistantId", (Object)this.assistantId()).add("Data", this.hasData() ? this.data() : null).add("Namespace", (Object)this.namespaceAsString()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespaceAsString()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionDataRequest, T> g) {
        return obj -> g.apply((UpdateSessionDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private List<RuntimeSessionData> data = DefaultSdkAutoConstructList.getInstance();
        private String namespace;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionDataRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.data(model.data);
            this.namespace(model.namespace);
            this.sessionId(model.sessionId);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final List<RuntimeSessionData.Builder> getData() {
            List<RuntimeSessionData.Builder> result = RuntimeSessionDataListCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<RuntimeSessionData.BuilderImpl> data) {
            this.data = RuntimeSessionDataListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<RuntimeSessionData> data) {
            this.data = RuntimeSessionDataListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(RuntimeSessionData ... data) {
            this.data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<RuntimeSessionData.Builder> ... data) {
            this.data(Stream.of(data).map(c -> (RuntimeSessionData)((RuntimeSessionData.Builder)RuntimeSessionData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(SessionDataNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionDataRequest build() {
            return new UpdateSessionDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSessionDataRequest> {
        public Builder assistantId(String var1);

        public Builder data(Collection<RuntimeSessionData> var1);

        public Builder data(RuntimeSessionData ... var1);

        public Builder data(Consumer<RuntimeSessionData.Builder> ... var1);

        public Builder namespace(String var1);

        public Builder namespace(SessionDataNamespace var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

