/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.Origin;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAiAgentVersionsRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, ListAiAgentVersionsRequest> {
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentId").getter(ListAiAgentVersionsRequest.getter(ListAiAgentVersionsRequest::aiAgentId)).setter(ListAiAgentVersionsRequest.setter(Builder::aiAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiAgentId").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(ListAiAgentVersionsRequest.getter(ListAiAgentVersionsRequest::assistantId)).setter(ListAiAgentVersionsRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAiAgentVersionsRequest.getter(ListAiAgentVersionsRequest::maxResults)).setter(ListAiAgentVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAiAgentVersionsRequest.getter(ListAiAgentVersionsRequest::nextToken)).setter(ListAiAgentVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("origin").getter(ListAiAgentVersionsRequest.getter(ListAiAgentVersionsRequest::originAsString)).setter(ListAiAgentVersionsRequest.setter(Builder::origin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("origin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_ID_FIELD, ASSISTANT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORIGIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("aiAgentId", AI_AGENT_ID_FIELD);
            this.put("assistantId", ASSISTANT_ID_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("origin", ORIGIN_FIELD);
        }
    });
    private final String aiAgentId;
    private final String assistantId;
    private final Integer maxResults;
    private final String nextToken;
    private final String origin;

    private ListAiAgentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.aiAgentId = builder.aiAgentId;
        this.assistantId = builder.assistantId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.origin = builder.origin;
    }

    public final String aiAgentId() {
        return this.aiAgentId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Origin origin() {
        return Origin.fromValue(this.origin);
    }

    public final String originAsString() {
        return this.origin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiAgentVersionsRequest)) {
            return false;
        }
        ListAiAgentVersionsRequest other = (ListAiAgentVersionsRequest)((Object)obj);
        return Objects.equals(this.aiAgentId(), other.aiAgentId()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.originAsString(), other.originAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListAiAgentVersionsRequest").add("AiAgentId", (Object)this.aiAgentId()).add("AssistantId", (Object)this.assistantId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Origin", (Object)this.originAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiAgentId": {
                return Optional.ofNullable(clazz.cast(this.aiAgentId()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "origin": {
                return Optional.ofNullable(clazz.cast(this.originAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAiAgentVersionsRequest, T> g) {
        return obj -> g.apply((ListAiAgentVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String aiAgentId;
        private String assistantId;
        private Integer maxResults;
        private String nextToken;
        private String origin;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiAgentVersionsRequest model) {
            super(model);
            this.aiAgentId(model.aiAgentId);
            this.assistantId(model.assistantId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.origin(model.origin);
        }

        public final String getAiAgentId() {
            return this.aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrigin() {
            return this.origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(Origin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAiAgentVersionsRequest build() {
            return new ListAiAgentVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAiAgentVersionsRequest> {
        public Builder aiAgentId(String var1);

        public Builder assistantId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder origin(String var1);

        public Builder origin(Origin var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

