/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KnowledgeBaseSearchType {
    HYBRID("HYBRID"),
    SEMANTIC("SEMANTIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KnowledgeBaseSearchType> VALUE_MAP;
    private final String value;

    private KnowledgeBaseSearchType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KnowledgeBaseSearchType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KnowledgeBaseSearchType> knownValues() {
        EnumSet<KnowledgeBaseSearchType> knownValues = EnumSet.allOf(KnowledgeBaseSearchType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KnowledgeBaseSearchType.class, KnowledgeBaseSearchType::toString);
    }
}

