/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIGuardrailVersionSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailVersionsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiGuardrailVersionsResponse;

public class ListAIGuardrailVersionsPublisher
implements SdkPublisher<ListAiGuardrailVersionsResponse> {
    private final QConnectAsyncClient client;
    private final ListAiGuardrailVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAIGuardrailVersionsPublisher(QConnectAsyncClient client, ListAiGuardrailVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAIGuardrailVersionsPublisher(QConnectAsyncClient client, ListAiGuardrailVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAiGuardrailVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAiGuardrailVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AIGuardrailVersionSummary> aiGuardrailVersionSummaries() {
        Function<ListAiGuardrailVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiGuardrailVersionSummaries() != null) {
                return response.aiGuardrailVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAiGuardrailVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAiGuardrailVersionsResponseFetcher
    implements AsyncPageFetcher<ListAiGuardrailVersionsResponse> {
        private ListAiGuardrailVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiGuardrailVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAiGuardrailVersionsResponse> nextPage(ListAiGuardrailVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAIGuardrailVersionsPublisher.this.client.listAIGuardrailVersions(ListAIGuardrailVersionsPublisher.this.firstRequest);
            }
            return ListAIGuardrailVersionsPublisher.this.client.listAIGuardrailVersions((ListAiGuardrailVersionsRequest)((Object)ListAIGuardrailVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

