/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qconnect.QConnectAsyncClient;
import software.amazon.awssdk.services.qconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.qconnect.model.AIAgentSummary;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsRequest;
import software.amazon.awssdk.services.qconnect.model.ListAiAgentsResponse;

public class ListAIAgentsPublisher
implements SdkPublisher<ListAiAgentsResponse> {
    private final QConnectAsyncClient client;
    private final ListAiAgentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAIAgentsPublisher(QConnectAsyncClient client, ListAiAgentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAIAgentsPublisher(QConnectAsyncClient client, ListAiAgentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAiAgentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAiAgentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AIAgentSummary> aiAgentSummaries() {
        Function<ListAiAgentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aiAgentSummaries() != null) {
                return response.aiAgentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAiAgentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAiAgentsResponseFetcher
    implements AsyncPageFetcher<ListAiAgentsResponse> {
        private ListAiAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAiAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAiAgentsResponse> nextPage(ListAiAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAIAgentsPublisher.this.client.listAIAgents(ListAIAgentsPublisher.this.firstRequest);
            }
            return ListAIAgentsPublisher.this.client.listAIAgents((ListAiAgentsRequest)((Object)ListAIAgentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

