/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A category used to classify and filter library items for Amazon Q Apps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Category implements SdkPojo, Serializable, ToCopyableBuilder<Category.Builder, Category> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Category::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Category::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("color")
            .getter(getter(Category::color)).setter(setter(Builder::color))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("color").build()).build();

    private static final SdkField<Integer> APP_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("appCount").getter(getter(Category::appCount)).setter(setter(Builder::appCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            COLOR_FIELD, APP_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final String color;

    private final Integer appCount;

    private Category(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.color = builder.color;
        this.appCount = builder.appCount;
    }

    /**
     * <p>
     * The unique identifier of the category.
     * </p>
     * 
     * @return The unique identifier of the category.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The title or name of the category.
     * </p>
     * 
     * @return The title or name of the category.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The color of the category
     * </p>
     * 
     * @return The color of the category
     */
    public final String color() {
        return color;
    }

    /**
     * <p>
     * The number of published Amazon Q Apps associated with a category
     * </p>
     * 
     * @return The number of published Amazon Q Apps associated with a category
     */
    public final Integer appCount() {
        return appCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(color());
        hashCode = 31 * hashCode + Objects.hashCode(appCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && Objects.equals(color(), other.color()) && Objects.equals(appCount(), other.appCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Category").add("Id", id()).add("Title", title()).add("Color", color())
                .add("AppCount", appCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "color":
            return Optional.ofNullable(clazz.cast(color()));
        case "appCount":
            return Optional.ofNullable(clazz.cast(appCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("color", COLOR_FIELD);
        map.put("appCount", APP_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Category, T> g) {
        return obj -> g.apply((Category) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Category> {
        /**
         * <p>
         * The unique identifier of the category.
         * </p>
         * 
         * @param id
         *        The unique identifier of the category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The title or name of the category.
         * </p>
         * 
         * @param title
         *        The title or name of the category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The color of the category
         * </p>
         * 
         * @param color
         *        The color of the category
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder color(String color);

        /**
         * <p>
         * The number of published Amazon Q Apps associated with a category
         * </p>
         * 
         * @param appCount
         *        The number of published Amazon Q Apps associated with a category
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appCount(Integer appCount);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private String color;

        private Integer appCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Category model) {
            id(model.id);
            title(model.title);
            color(model.color);
            appCount(model.appCount);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getColor() {
            return color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Integer getAppCount() {
            return appCount;
        }

        public final void setAppCount(Integer appCount) {
            this.appCount = appCount;
        }

        @Override
        public final Builder appCount(Integer appCount) {
            this.appCount = appCount;
            return this;
        }

        @Override
        public Category build() {
            return new Category(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
