/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.CategoriesListCopier;
import software.amazon.awssdk.services.qapps.model.Category;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCategoriesResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, ListCategoriesResponse> {
    private static final SdkField<List<Category>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("categories").getter(ListCategoriesResponse.getter(ListCategoriesResponse::categories)).setter(ListCategoriesResponse.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Category::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCategoriesResponse.memberNameToFieldInitializer();
    private final List<Category> categories;

    private ListCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.categories = builder.categories;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<Category> categories() {
        return this.categories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCategoriesResponse)) {
            return false;
        }
        ListCategoriesResponse other = (ListCategoriesResponse)((Object)obj);
        return this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories());
    }

    public final String toString() {
        return ToString.builder((String)"ListCategoriesResponse").add("Categories", this.hasCategories() ? this.categories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Category>>> map = new HashMap<String, SdkField<List<Category>>>();
        map.put("categories", CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCategoriesResponse, T> g) {
        return obj -> g.apply((ListCategoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private List<Category> categories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCategoriesResponse model) {
            super(model);
            this.categories(model.categories);
        }

        public final List<Category.Builder> getCategories() {
            List<Category.Builder> result = CategoriesListCopier.copyToBuilder(this.categories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategories(Collection<Category.BuilderImpl> categories) {
            this.categories = CategoriesListCopier.copyFromBuilder(categories);
        }

        @Override
        public final Builder categories(Collection<Category> categories) {
            this.categories = CategoriesListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Category ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(Consumer<Category.Builder> ... categories) {
            this.categories(Stream.of(categories).map(c -> (Category)((Category.Builder)Category.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCategoriesResponse build() {
            return new ListCategoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCategoriesResponse> {
        public Builder categories(Collection<Category> var1);

        public Builder categories(Category ... var1);

        public Builder categories(Consumer<Category.Builder> ... var1);
    }
}

