/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.QAppSessionData;
import software.amazon.awssdk.services.qapps.model.QAppSessionDataListCopier;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQAppSessionDataResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, ListQAppSessionDataResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(ListQAppSessionDataResponse.getter(ListQAppSessionDataResponse::sessionId)).setter(ListQAppSessionDataResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(ListQAppSessionDataResponse.getter(ListQAppSessionDataResponse::sessionArn)).setter(ListQAppSessionDataResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<List<QAppSessionData>> SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionData").getter(ListQAppSessionDataResponse.getter(ListQAppSessionDataResponse::sessionData)).setter(ListQAppSessionDataResponse.setter(Builder::sessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QAppSessionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQAppSessionDataResponse.getter(ListQAppSessionDataResponse::nextToken)).setter(ListQAppSessionDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, SESSION_ARN_FIELD, SESSION_DATA_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQAppSessionDataResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String sessionArn;
    private final List<QAppSessionData> sessionData;
    private final String nextToken;

    private ListQAppSessionDataResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.sessionData = builder.sessionData;
        this.nextToken = builder.nextToken;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final boolean hasSessionData() {
        return this.sessionData != null && !(this.sessionData instanceof SdkAutoConstructList);
    }

    public final List<QAppSessionData> sessionData() {
        return this.sessionData;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionData() ? this.sessionData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQAppSessionDataResponse)) {
            return false;
        }
        ListQAppSessionDataResponse other = (ListQAppSessionDataResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionArn(), other.sessionArn()) && this.hasSessionData() == other.hasSessionData() && Objects.equals(this.sessionData(), other.sessionData()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListQAppSessionDataResponse").add("SessionId", (Object)this.sessionId()).add("SessionArn", (Object)this.sessionArn()).add("SessionData", this.hasSessionData() ? this.sessionData() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "sessionData": {
                return Optional.ofNullable(clazz.cast(this.sessionData()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionData", SESSION_DATA_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQAppSessionDataResponse, T> g) {
        return obj -> g.apply((ListQAppSessionDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String sessionArn;
        private List<QAppSessionData> sessionData = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQAppSessionDataResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.sessionArn(model.sessionArn);
            this.sessionData(model.sessionData);
            this.nextToken(model.nextToken);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final List<QAppSessionData.Builder> getSessionData() {
            List<QAppSessionData.Builder> result = QAppSessionDataListCopier.copyToBuilder(this.sessionData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionData(Collection<QAppSessionData.BuilderImpl> sessionData) {
            this.sessionData = QAppSessionDataListCopier.copyFromBuilder(sessionData);
        }

        @Override
        public final Builder sessionData(Collection<QAppSessionData> sessionData) {
            this.sessionData = QAppSessionDataListCopier.copy(sessionData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionData(QAppSessionData ... sessionData) {
            this.sessionData(Arrays.asList(sessionData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionData(Consumer<QAppSessionData.Builder> ... sessionData) {
            this.sessionData(Stream.of(sessionData).map(c -> (QAppSessionData)((QAppSessionData.Builder)QAppSessionData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQAppSessionDataResponse build() {
            return new ListQAppSessionDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQAppSessionDataResponse> {
        public Builder sessionId(String var1);

        public Builder sessionArn(String var1);

        public Builder sessionData(Collection<QAppSessionData> var1);

        public Builder sessionData(QAppSessionData ... var1);

        public Builder sessionData(Consumer<QAppSessionData.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

