/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileUploadCardInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileUploadCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(FileUploadCardInput.getter(FileUploadCardInput::title)).setter(FileUploadCardInput.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(FileUploadCardInput.getter(FileUploadCardInput::id)).setter(FileUploadCardInput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FileUploadCardInput.getter(FileUploadCardInput::typeAsString)).setter(FileUploadCardInput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> FILENAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filename").getter(FileUploadCardInput.getter(FileUploadCardInput::filename)).setter(FileUploadCardInput.setter(Builder::filename)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filename").build()}).build();
    private static final SdkField<String> FILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileId").getter(FileUploadCardInput.getter(FileUploadCardInput::fileId)).setter(FileUploadCardInput.setter(Builder::fileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()}).build();
    private static final SdkField<Boolean> ALLOW_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowOverride").getter(FileUploadCardInput.getter(FileUploadCardInput::allowOverride)).setter(FileUploadCardInput.setter(Builder::allowOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD, TYPE_FIELD, FILENAME_FIELD, FILE_ID_FIELD, ALLOW_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("title", TITLE_FIELD);
            this.put("id", ID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("filename", FILENAME_FIELD);
            this.put("fileId", FILE_ID_FIELD);
            this.put("allowOverride", ALLOW_OVERRIDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String id;
    private final String type;
    private final String filename;
    private final String fileId;
    private final Boolean allowOverride;

    private FileUploadCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.filename = builder.filename;
        this.fileId = builder.fileId;
        this.allowOverride = builder.allowOverride;
    }

    public final String title() {
        return this.title;
    }

    public final String id() {
        return this.id;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String filename() {
        return this.filename;
    }

    public final String fileId() {
        return this.fileId;
    }

    public final Boolean allowOverride() {
        return this.allowOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filename());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileUploadCardInput)) {
            return false;
        }
        FileUploadCardInput other = (FileUploadCardInput)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.filename(), other.filename()) && Objects.equals(this.fileId(), other.fileId()) && Objects.equals(this.allowOverride(), other.allowOverride());
    }

    public final String toString() {
        return ToString.builder((String)"FileUploadCardInput").add("Title", (Object)this.title()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Filename", (Object)this.filename()).add("FileId", (Object)this.fileId()).add("AllowOverride", (Object)this.allowOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "filename": {
                return Optional.ofNullable(clazz.cast(this.filename()));
            }
            case "fileId": {
                return Optional.ofNullable(clazz.cast(this.fileId()));
            }
            case "allowOverride": {
                return Optional.ofNullable(clazz.cast(this.allowOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileUploadCardInput, T> g) {
        return obj -> g.apply((FileUploadCardInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String id;
        private String type;
        private String filename;
        private String fileId;
        private Boolean allowOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(FileUploadCardInput model) {
            this.title(model.title);
            this.id(model.id);
            this.type(model.type);
            this.filename(model.filename);
            this.fileId(model.fileId);
            this.allowOverride(model.allowOverride);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFilename() {
            return this.filename;
        }

        public final void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public final Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public final String getFileId() {
            return this.fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final Boolean getAllowOverride() {
            return this.allowOverride;
        }

        public final void setAllowOverride(Boolean allowOverride) {
            this.allowOverride = allowOverride;
        }

        @Override
        public final Builder allowOverride(Boolean allowOverride) {
            this.allowOverride = allowOverride;
            return this;
        }

        public FileUploadCardInput build() {
            return new FileUploadCardInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileUploadCardInput> {
        public Builder title(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder filename(String var1);

        public Builder fileId(String var1);

        public Builder allowOverride(Boolean var1);
    }
}

