/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.ConversationMessage;
import software.amazon.awssdk.services.qapps.model.PredictQAppInputOptionsConversationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictQAppInputOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictQAppInputOptions> {
    private static final SdkField<List<ConversationMessage>> CONVERSATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conversation").getter(PredictQAppInputOptions.getter(PredictQAppInputOptions::conversation)).setter(PredictQAppInputOptions.setter(Builder::conversation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConversationMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROBLEM_STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("problemStatement").getter(PredictQAppInputOptions.getter(PredictQAppInputOptions::problemStatement)).setter(PredictQAppInputOptions.setter(Builder::problemStatement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("problemStatement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_FIELD, PROBLEM_STATEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("conversation", CONVERSATION_FIELD);
            this.put("problemStatement", PROBLEM_STATEMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ConversationMessage> conversation;
    private final String problemStatement;
    private final Type type;

    private PredictQAppInputOptions(BuilderImpl builder) {
        this.conversation = builder.conversation;
        this.problemStatement = builder.problemStatement;
        this.type = builder.type;
    }

    public final boolean hasConversation() {
        return this.conversation != null && !(this.conversation instanceof SdkAutoConstructList);
    }

    public final List<ConversationMessage> conversation() {
        return this.conversation;
    }

    public final String problemStatement() {
        return this.problemStatement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConversation() ? this.conversation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.problemStatement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQAppInputOptions)) {
            return false;
        }
        PredictQAppInputOptions other = (PredictQAppInputOptions)obj;
        return this.hasConversation() == other.hasConversation() && Objects.equals(this.conversation(), other.conversation()) && Objects.equals(this.problemStatement(), other.problemStatement());
    }

    public final String toString() {
        return ToString.builder((String)"PredictQAppInputOptions").add("Conversation", this.hasConversation() ? this.conversation() : null).add("ProblemStatement", (Object)this.problemStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversation": {
                return Optional.ofNullable(clazz.cast(this.conversation()));
            }
            case "problemStatement": {
                return Optional.ofNullable(clazz.cast(this.problemStatement()));
            }
        }
        return Optional.empty();
    }

    public static PredictQAppInputOptions fromConversation(List<ConversationMessage> conversation) {
        return (PredictQAppInputOptions)PredictQAppInputOptions.builder().conversation(conversation).build();
    }

    public static PredictQAppInputOptions fromProblemStatement(String problemStatement) {
        return (PredictQAppInputOptions)PredictQAppInputOptions.builder().problemStatement(problemStatement).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PredictQAppInputOptions, T> g) {
        return obj -> g.apply((PredictQAppInputOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONVERSATION,
        PROBLEM_STATEMENT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<ConversationMessage> conversation = DefaultSdkAutoConstructList.getInstance();
        private String problemStatement;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQAppInputOptions model) {
            this.conversation(model.conversation);
            this.problemStatement(model.problemStatement);
        }

        public final List<ConversationMessage.Builder> getConversation() {
            List<ConversationMessage.Builder> result = PredictQAppInputOptionsConversationListCopier.copyToBuilder(this.conversation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConversation(Collection<ConversationMessage.BuilderImpl> conversation) {
            List<ConversationMessage> oldValue = this.conversation;
            this.conversation = PredictQAppInputOptionsConversationListCopier.copyFromBuilder(conversation);
            this.handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
        }

        @Override
        public final Builder conversation(Collection<ConversationMessage> conversation) {
            List<ConversationMessage> oldValue = this.conversation;
            this.conversation = PredictQAppInputOptionsConversationListCopier.copy(conversation);
            this.handleUnionValueChange(Type.CONVERSATION, oldValue, this.conversation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversation(ConversationMessage ... conversation) {
            this.conversation(Arrays.asList(conversation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversation(Consumer<ConversationMessage.Builder> ... conversation) {
            this.conversation(Stream.of(conversation).map(c -> (ConversationMessage)((ConversationMessage.Builder)ConversationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProblemStatement() {
            return this.problemStatement;
        }

        public final void setProblemStatement(String problemStatement) {
            String oldValue = this.problemStatement;
            this.problemStatement = problemStatement;
            this.handleUnionValueChange(Type.PROBLEM_STATEMENT, oldValue, this.problemStatement);
        }

        @Override
        public final Builder problemStatement(String problemStatement) {
            String oldValue = this.problemStatement;
            this.problemStatement = problemStatement;
            this.handleUnionValueChange(Type.PROBLEM_STATEMENT, oldValue, this.problemStatement);
            return this;
        }

        public PredictQAppInputOptions build() {
            return new PredictQAppInputOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictQAppInputOptions> {
        public Builder conversation(Collection<ConversationMessage> var1);

        public Builder conversation(ConversationMessage ... var1);

        public Builder conversation(Consumer<ConversationMessage.Builder> ... var1);

        public Builder problemStatement(String var1);
    }
}

