/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.AttributeFilter;
import software.amazon.awssdk.services.qapps.model.CardOutputSource;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.services.qapps.model.DependencyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QQueryCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QQueryCard> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(QQueryCard.getter(QQueryCard::id)).setter(QQueryCard.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(QQueryCard.getter(QQueryCard::title)).setter(QQueryCard.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(QQueryCard.getter(QQueryCard::dependencies)).setter(QQueryCard.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(QQueryCard.getter(QQueryCard::typeAsString)).setter(QQueryCard.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prompt").getter(QQueryCard.getter(QQueryCard::prompt)).setter(QQueryCard.setter(Builder::prompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()}).build();
    private static final SdkField<String> OUTPUT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputSource").getter(QQueryCard.getter(QQueryCard::outputSourceAsString)).setter(QQueryCard.setter(Builder::outputSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSource").build()}).build();
    private static final SdkField<AttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributeFilter").getter(QQueryCard.getter(QQueryCard::attributeFilter)).setter(QQueryCard.setter(Builder::attributeFilter)).constructor(AttributeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, DEPENDENCIES_FIELD, TYPE_FIELD, PROMPT_FIELD, OUTPUT_SOURCE_FIELD, ATTRIBUTE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("dependencies", DEPENDENCIES_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("prompt", PROMPT_FIELD);
            this.put("outputSource", OUTPUT_SOURCE_FIELD);
            this.put("attributeFilter", ATTRIBUTE_FILTER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final List<String> dependencies;
    private final String type;
    private final String prompt;
    private final String outputSource;
    private final AttributeFilter attributeFilter;

    private QQueryCard(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.dependencies = builder.dependencies;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.outputSource = builder.outputSource;
        this.attributeFilter = builder.attributeFilter;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<String> dependencies() {
        return this.dependencies;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String prompt() {
        return this.prompt;
    }

    public final CardOutputSource outputSource() {
        return CardOutputSource.fromValue(this.outputSource);
    }

    public final String outputSourceAsString() {
        return this.outputSource;
    }

    public final AttributeFilter attributeFilter() {
        return this.attributeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QQueryCard)) {
            return false;
        }
        QQueryCard other = (QQueryCard)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.prompt(), other.prompt()) && Objects.equals(this.outputSourceAsString(), other.outputSourceAsString()) && Objects.equals(this.attributeFilter(), other.attributeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"QQueryCard").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).add("Type", (Object)this.typeAsString()).add("Prompt", (Object)this.prompt()).add("OutputSource", (Object)this.outputSourceAsString()).add("AttributeFilter", (Object)this.attributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "prompt": {
                return Optional.ofNullable(clazz.cast(this.prompt()));
            }
            case "outputSource": {
                return Optional.ofNullable(clazz.cast(this.outputSourceAsString()));
            }
            case "attributeFilter": {
                return Optional.ofNullable(clazz.cast(this.attributeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QQueryCard, T> g) {
        return obj -> g.apply((QQueryCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String prompt;
        private String outputSource;
        private AttributeFilter attributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(QQueryCard model) {
            this.id(model.id);
            this.title(model.title);
            this.dependencies(model.dependencies);
            this.type(model.type);
            this.prompt(model.prompt);
            this.outputSource(model.outputSource);
            this.attributeFilter(model.attributeFilter);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (this.dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return this.prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getOutputSource() {
            return this.outputSource;
        }

        public final void setOutputSource(String outputSource) {
            this.outputSource = outputSource;
        }

        @Override
        public final Builder outputSource(String outputSource) {
            this.outputSource = outputSource;
            return this;
        }

        @Override
        public final Builder outputSource(CardOutputSource outputSource) {
            this.outputSource(outputSource == null ? null : outputSource.toString());
            return this;
        }

        public final AttributeFilter.Builder getAttributeFilter() {
            return this.attributeFilter != null ? this.attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(AttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        public QQueryCard build() {
            return new QQueryCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QQueryCard> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder dependencies(Collection<String> var1);

        public Builder dependencies(String ... var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder prompt(String var1);

        public Builder outputSource(String var1);

        public Builder outputSource(CardOutputSource var1);

        public Builder attributeFilter(AttributeFilter var1);

        default public Builder attributeFilter(Consumer<AttributeFilter.Builder> attributeFilter) {
            return this.attributeFilter((AttributeFilter)((AttributeFilter.Builder)AttributeFilter.builder().applyMutation(attributeFilter)).build());
        }
    }
}

