/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentTemplateVersionResponse extends ProtonResponse implements
        ToCopyableBuilder<UpdateEnvironmentTemplateVersionResponse.Builder, UpdateEnvironmentTemplateVersionResponse> {
    private static final SdkField<EnvironmentTemplateVersion> ENVIRONMENT_TEMPLATE_VERSION_FIELD = SdkField
            .<EnvironmentTemplateVersion> builder(MarshallingType.SDK_POJO)
            .memberName("environmentTemplateVersion")
            .getter(getter(UpdateEnvironmentTemplateVersionResponse::environmentTemplateVersion))
            .setter(setter(Builder::environmentTemplateVersion))
            .constructor(EnvironmentTemplateVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentTemplateVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENVIRONMENT_TEMPLATE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EnvironmentTemplateVersion environmentTemplateVersion;

    private UpdateEnvironmentTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.environmentTemplateVersion = builder.environmentTemplateVersion;
    }

    /**
     * <p>
     * The environment template version detail data that's returned by Proton.
     * </p>
     * 
     * @return The environment template version detail data that's returned by Proton.
     */
    public final EnvironmentTemplateVersion environmentTemplateVersion() {
        return environmentTemplateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentTemplateVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentTemplateVersionResponse)) {
            return false;
        }
        UpdateEnvironmentTemplateVersionResponse other = (UpdateEnvironmentTemplateVersionResponse) obj;
        return Objects.equals(environmentTemplateVersion(), other.environmentTemplateVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentTemplateVersionResponse")
                .add("EnvironmentTemplateVersion", environmentTemplateVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentTemplateVersion":
            return Optional.ofNullable(clazz.cast(environmentTemplateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentTemplateVersion", ENVIRONMENT_TEMPLATE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentTemplateVersionResponse, T> g) {
        return obj -> g.apply((UpdateEnvironmentTemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ProtonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnvironmentTemplateVersionResponse> {
        /**
         * <p>
         * The environment template version detail data that's returned by Proton.
         * </p>
         * 
         * @param environmentTemplateVersion
         *        The environment template version detail data that's returned by Proton.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentTemplateVersion(EnvironmentTemplateVersion environmentTemplateVersion);

        /**
         * <p>
         * The environment template version detail data that's returned by Proton.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentTemplateVersion.Builder}
         * avoiding the need to create one manually via {@link EnvironmentTemplateVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentTemplateVersion.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentTemplateVersion(EnvironmentTemplateVersion)}.
         * 
         * @param environmentTemplateVersion
         *        a consumer that will call methods on {@link EnvironmentTemplateVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentTemplateVersion(EnvironmentTemplateVersion)
         */
        default Builder environmentTemplateVersion(Consumer<EnvironmentTemplateVersion.Builder> environmentTemplateVersion) {
            return environmentTemplateVersion(EnvironmentTemplateVersion.builder().applyMutation(environmentTemplateVersion)
                    .build());
        }
    }

    static final class BuilderImpl extends ProtonResponse.BuilderImpl implements Builder {
        private EnvironmentTemplateVersion environmentTemplateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentTemplateVersionResponse model) {
            super(model);
            environmentTemplateVersion(model.environmentTemplateVersion);
        }

        public final EnvironmentTemplateVersion.Builder getEnvironmentTemplateVersion() {
            return environmentTemplateVersion != null ? environmentTemplateVersion.toBuilder() : null;
        }

        public final void setEnvironmentTemplateVersion(EnvironmentTemplateVersion.BuilderImpl environmentTemplateVersion) {
            this.environmentTemplateVersion = environmentTemplateVersion != null ? environmentTemplateVersion.build() : null;
        }

        @Override
        public final Builder environmentTemplateVersion(EnvironmentTemplateVersion environmentTemplateVersion) {
            this.environmentTemplateVersion = environmentTemplateVersion;
            return this;
        }

        @Override
        public UpdateEnvironmentTemplateVersionResponse build() {
            return new UpdateEnvironmentTemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
