/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_FAILED_CLEANUP_IN_PROGRESS("CREATE_FAILED_CLEANUP_IN_PROGRESS"),
    CREATE_FAILED_CLEANUP_COMPLETE("CREATE_FAILED_CLEANUP_COMPLETE"),
    CREATE_FAILED_CLEANUP_FAILED("CREATE_FAILED_CLEANUP_FAILED"),
    CREATE_FAILED("CREATE_FAILED"),
    ACTIVE("ACTIVE"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_FAILED("DELETE_FAILED"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    UPDATE_FAILED_CLEANUP_IN_PROGRESS("UPDATE_FAILED_CLEANUP_IN_PROGRESS"),
    UPDATE_FAILED_CLEANUP_COMPLETE("UPDATE_FAILED_CLEANUP_COMPLETE"),
    UPDATE_FAILED_CLEANUP_FAILED("UPDATE_FAILED_CLEANUP_FAILED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UPDATE_COMPLETE_CLEANUP_FAILED("UPDATE_COMPLETE_CLEANUP_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceStatus> VALUE_MAP;
    private final String value;

    private ServiceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceStatus> knownValues() {
        EnumSet<ServiceStatus> knownValues = EnumSet.allOf(ServiceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceStatus.class, ServiceStatus::toString);
    }
}

