/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, GetDeploymentRequest> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(GetDeploymentRequest.getter(GetDeploymentRequest::componentName)).setter(GetDeploymentRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(GetDeploymentRequest.getter(GetDeploymentRequest::environmentName)).setter(GetDeploymentRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetDeploymentRequest.getter(GetDeploymentRequest::id)).setter(GetDeploymentRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(GetDeploymentRequest.getter(GetDeploymentRequest::serviceInstanceName)).setter(GetDeploymentRequest.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(GetDeploymentRequest.getter(GetDeploymentRequest::serviceName)).setter(GetDeploymentRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeploymentRequest.memberNameToFieldInitializer();
    private final String componentName;
    private final String environmentName;
    private final String id;
    private final String serviceInstanceName;
    private final String serviceName;

    private GetDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.componentName = builder.componentName;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String id() {
        return this.id;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentRequest)) {
            return false;
        }
        GetDeploymentRequest other = (GetDeploymentRequest)((Object)obj);
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeploymentRequest").add("ComponentName", (Object)this.componentName()).add("EnvironmentName", (Object)this.environmentName()).add("Id", (Object)this.id()).add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentRequest, T> g) {
        return obj -> g.apply((GetDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String componentName;
        private String environmentName;
        private String id;
        private String serviceInstanceName;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentRequest model) {
            super(model);
            this.componentName(model.componentName);
            this.environmentName(model.environmentName);
            this.id(model.id);
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDeploymentRequest build() {
            return new GetDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentRequest> {
        public Builder componentName(String var1);

        public Builder environmentName(String var1);

        public Builder id(String var1);

        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

