/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.LatestSyncBlockersCopier;
import software.amazon.awssdk.services.proton.model.SyncBlocker;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSyncBlockerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSyncBlockerSummary> {
    private static final SdkField<List<SyncBlocker>> LATEST_BLOCKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("latestBlockers").getter(ServiceSyncBlockerSummary.getter(ServiceSyncBlockerSummary::latestBlockers)).setter(ServiceSyncBlockerSummary.setter(Builder::latestBlockers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestBlockers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncBlocker::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceInstanceName").getter(ServiceSyncBlockerSummary.getter(ServiceSyncBlockerSummary::serviceInstanceName)).setter(ServiceSyncBlockerSummary.setter(Builder::serviceInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstanceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(ServiceSyncBlockerSummary.getter(ServiceSyncBlockerSummary::serviceName)).setter(ServiceSyncBlockerSummary.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_BLOCKERS_FIELD, SERVICE_INSTANCE_NAME_FIELD, SERVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("latestBlockers", LATEST_BLOCKERS_FIELD);
            this.put("serviceInstanceName", SERVICE_INSTANCE_NAME_FIELD);
            this.put("serviceName", SERVICE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<SyncBlocker> latestBlockers;
    private final String serviceInstanceName;
    private final String serviceName;

    private ServiceSyncBlockerSummary(BuilderImpl builder) {
        this.latestBlockers = builder.latestBlockers;
        this.serviceInstanceName = builder.serviceInstanceName;
        this.serviceName = builder.serviceName;
    }

    public final boolean hasLatestBlockers() {
        return this.latestBlockers != null && !(this.latestBlockers instanceof SdkAutoConstructList);
    }

    public final List<SyncBlocker> latestBlockers() {
        return this.latestBlockers;
    }

    public final String serviceInstanceName() {
        return this.serviceInstanceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestBlockers() ? this.latestBlockers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSyncBlockerSummary)) {
            return false;
        }
        ServiceSyncBlockerSummary other = (ServiceSyncBlockerSummary)obj;
        return this.hasLatestBlockers() == other.hasLatestBlockers() && Objects.equals(this.latestBlockers(), other.latestBlockers()) && Objects.equals(this.serviceInstanceName(), other.serviceInstanceName()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceSyncBlockerSummary").add("LatestBlockers", this.hasLatestBlockers() ? this.latestBlockers() : null).add("ServiceInstanceName", (Object)this.serviceInstanceName()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "latestBlockers": {
                return Optional.ofNullable(clazz.cast(this.latestBlockers()));
            }
            case "serviceInstanceName": {
                return Optional.ofNullable(clazz.cast(this.serviceInstanceName()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSyncBlockerSummary, T> g) {
        return obj -> g.apply((ServiceSyncBlockerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SyncBlocker> latestBlockers = DefaultSdkAutoConstructList.getInstance();
        private String serviceInstanceName;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSyncBlockerSummary model) {
            this.latestBlockers(model.latestBlockers);
            this.serviceInstanceName(model.serviceInstanceName);
            this.serviceName(model.serviceName);
        }

        public final List<SyncBlocker.Builder> getLatestBlockers() {
            List<SyncBlocker.Builder> result = LatestSyncBlockersCopier.copyToBuilder(this.latestBlockers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestBlockers(Collection<SyncBlocker.BuilderImpl> latestBlockers) {
            this.latestBlockers = LatestSyncBlockersCopier.copyFromBuilder(latestBlockers);
        }

        @Override
        public final Builder latestBlockers(Collection<SyncBlocker> latestBlockers) {
            this.latestBlockers = LatestSyncBlockersCopier.copy(latestBlockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(SyncBlocker ... latestBlockers) {
            this.latestBlockers(Arrays.asList(latestBlockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(Consumer<SyncBlocker.Builder> ... latestBlockers) {
            this.latestBlockers(Stream.of(latestBlockers).map(c -> (SyncBlocker)((SyncBlocker.Builder)SyncBlocker.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceInstanceName() {
            return this.serviceInstanceName;
        }

        public final void setServiceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
        }

        @Override
        public final Builder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceSyncBlockerSummary build() {
            return new ServiceSyncBlockerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSyncBlockerSummary> {
        public Builder latestBlockers(Collection<SyncBlocker> var1);

        public Builder latestBlockers(SyncBlocker ... var1);

        public Builder latestBlockers(Consumer<SyncBlocker.Builder> ... var1);

        public Builder serviceInstanceName(String var1);

        public Builder serviceName(String var1);
    }
}

