/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.ProtonResponse;
import software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary;
import software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceTemplateVersionsResponse
extends ProtonResponse
implements ToCopyableBuilder<Builder, ListServiceTemplateVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServiceTemplateVersionsResponse.getter(ListServiceTemplateVersionsResponse::nextToken)).setter(ListServiceTemplateVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ServiceTemplateVersionSummary>> TEMPLATE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templateVersions").getter(ListServiceTemplateVersionsResponse.getter(ListServiceTemplateVersionsResponse::templateVersions)).setter(ListServiceTemplateVersionsResponse.setter(Builder::templateVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceTemplateVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEMPLATE_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("templateVersions", TEMPLATE_VERSIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ServiceTemplateVersionSummary> templateVersions;

    private ListServiceTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.templateVersions = builder.templateVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTemplateVersions() {
        return this.templateVersions != null && !(this.templateVersions instanceof SdkAutoConstructList);
    }

    public final List<ServiceTemplateVersionSummary> templateVersions() {
        return this.templateVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateVersions() ? this.templateVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceTemplateVersionsResponse)) {
            return false;
        }
        ListServiceTemplateVersionsResponse other = (ListServiceTemplateVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTemplateVersions() == other.hasTemplateVersions() && Objects.equals(this.templateVersions(), other.templateVersions());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceTemplateVersionsResponse").add("NextToken", (Object)this.nextToken()).add("TemplateVersions", this.hasTemplateVersions() ? this.templateVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "templateVersions": {
                return Optional.ofNullable(clazz.cast(this.templateVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceTemplateVersionsResponse, T> g) {
        return obj -> g.apply((ListServiceTemplateVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceTemplateVersionSummary> templateVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceTemplateVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.templateVersions(model.templateVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServiceTemplateVersionSummary.Builder> getTemplateVersions() {
            List<ServiceTemplateVersionSummary.Builder> result = ServiceTemplateVersionSummaryListCopier.copyToBuilder(this.templateVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateVersions(Collection<ServiceTemplateVersionSummary.BuilderImpl> templateVersions) {
            this.templateVersions = ServiceTemplateVersionSummaryListCopier.copyFromBuilder(templateVersions);
        }

        @Override
        public final Builder templateVersions(Collection<ServiceTemplateVersionSummary> templateVersions) {
            this.templateVersions = ServiceTemplateVersionSummaryListCopier.copy(templateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateVersions(ServiceTemplateVersionSummary ... templateVersions) {
            this.templateVersions(Arrays.asList(templateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateVersions(Consumer<ServiceTemplateVersionSummary.Builder> ... templateVersions) {
            this.templateVersions(Stream.of(templateVersions).map(c -> (ServiceTemplateVersionSummary)((ServiceTemplateVersionSummary.Builder)ServiceTemplateVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListServiceTemplateVersionsResponse build() {
            return new ListServiceTemplateVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ProtonResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceTemplateVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder templateVersions(Collection<ServiceTemplateVersionSummary> var1);

        public Builder templateVersions(ServiceTemplateVersionSummary ... var1);

        public Builder templateVersions(Consumer<ServiceTemplateVersionSummary.Builder> ... var1);
    }
}

