/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlockerType {
    AUTOMATED("AUTOMATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlockerType> VALUE_MAP;
    private final String value;

    private BlockerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlockerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlockerType> knownValues() {
        EnumSet<BlockerType> knownValues = EnumSet.allOf(BlockerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlockerType.class, BlockerType::toString);
    }
}

