/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.proton.model.BlockerStatus;
import software.amazon.awssdk.services.proton.model.BlockerType;
import software.amazon.awssdk.services.proton.model.SyncBlockerContext;
import software.amazon.awssdk.services.proton.model.SyncBlockerContextsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncBlocker
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyncBlocker> {
    private static final SdkField<List<SyncBlockerContext>> CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contexts").getter(SyncBlocker.getter(SyncBlocker::contexts)).setter(SyncBlocker.setter(Builder::contexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncBlockerContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SyncBlocker.getter(SyncBlocker::createdAt)).setter(SyncBlocker.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdReason").getter(SyncBlocker.getter(SyncBlocker::createdReason)).setter(SyncBlocker.setter(Builder::createdReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdReason").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SyncBlocker.getter(SyncBlocker::id)).setter(SyncBlocker.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> RESOLVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resolvedAt").getter(SyncBlocker.getter(SyncBlocker::resolvedAt)).setter(SyncBlocker.setter(Builder::resolvedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedAt").build()}).build();
    private static final SdkField<String> RESOLVED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolvedReason").getter(SyncBlocker.getter(SyncBlocker::resolvedReason)).setter(SyncBlocker.setter(Builder::resolvedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedReason").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SyncBlocker.getter(SyncBlocker::statusAsString)).setter(SyncBlocker.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SyncBlocker.getter(SyncBlocker::typeAsString)).setter(SyncBlocker.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXTS_FIELD, CREATED_AT_FIELD, CREATED_REASON_FIELD, ID_FIELD, RESOLVED_AT_FIELD, RESOLVED_REASON_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<SyncBlockerContext> contexts;
    private final Instant createdAt;
    private final String createdReason;
    private final String id;
    private final Instant resolvedAt;
    private final String resolvedReason;
    private final String status;
    private final String type;

    private SyncBlocker(BuilderImpl builder) {
        this.contexts = builder.contexts;
        this.createdAt = builder.createdAt;
        this.createdReason = builder.createdReason;
        this.id = builder.id;
        this.resolvedAt = builder.resolvedAt;
        this.resolvedReason = builder.resolvedReason;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final boolean hasContexts() {
        return this.contexts != null && !(this.contexts instanceof SdkAutoConstructList);
    }

    public final List<SyncBlockerContext> contexts() {
        return this.contexts;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdReason() {
        return this.createdReason;
    }

    public final String id() {
        return this.id;
    }

    public final Instant resolvedAt() {
        return this.resolvedAt;
    }

    public final String resolvedReason() {
        return this.resolvedReason;
    }

    public final BlockerStatus status() {
        return BlockerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final BlockerType type() {
        return BlockerType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContexts() ? this.contexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncBlocker)) {
            return false;
        }
        SyncBlocker other = (SyncBlocker)obj;
        return this.hasContexts() == other.hasContexts() && Objects.equals(this.contexts(), other.contexts()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdReason(), other.createdReason()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.resolvedAt(), other.resolvedAt()) && Objects.equals(this.resolvedReason(), other.resolvedReason()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SyncBlocker").add("Contexts", this.hasContexts() ? this.contexts() : null).add("CreatedAt", (Object)this.createdAt()).add("CreatedReason", (Object)this.createdReason()).add("Id", (Object)this.id()).add("ResolvedAt", (Object)this.resolvedAt()).add("ResolvedReason", (Object)this.resolvedReason()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contexts": {
                return Optional.ofNullable(clazz.cast(this.contexts()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdReason": {
                return Optional.ofNullable(clazz.cast(this.createdReason()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "resolvedAt": {
                return Optional.ofNullable(clazz.cast(this.resolvedAt()));
            }
            case "resolvedReason": {
                return Optional.ofNullable(clazz.cast(this.resolvedReason()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SyncBlocker, T> g) {
        return obj -> g.apply((SyncBlocker)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SyncBlockerContext> contexts = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String createdReason;
        private String id;
        private Instant resolvedAt;
        private String resolvedReason;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncBlocker model) {
            this.contexts(model.contexts);
            this.createdAt(model.createdAt);
            this.createdReason(model.createdReason);
            this.id(model.id);
            this.resolvedAt(model.resolvedAt);
            this.resolvedReason(model.resolvedReason);
            this.status(model.status);
            this.type(model.type);
        }

        public final List<SyncBlockerContext.Builder> getContexts() {
            List<SyncBlockerContext.Builder> result = SyncBlockerContextsCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<SyncBlockerContext.BuilderImpl> contexts) {
            this.contexts = SyncBlockerContextsCopier.copyFromBuilder(contexts);
        }

        @Override
        public final Builder contexts(Collection<SyncBlockerContext> contexts) {
            this.contexts = SyncBlockerContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(SyncBlockerContext ... contexts) {
            this.contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<SyncBlockerContext.Builder> ... contexts) {
            this.contexts(Stream.of(contexts).map(c -> (SyncBlockerContext)((SyncBlockerContext.Builder)SyncBlockerContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedReason() {
            return this.createdReason;
        }

        public final void setCreatedReason(String createdReason) {
            this.createdReason = createdReason;
        }

        @Override
        public final Builder createdReason(String createdReason) {
            this.createdReason = createdReason;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getResolvedAt() {
            return this.resolvedAt;
        }

        public final void setResolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
        }

        @Override
        public final Builder resolvedAt(Instant resolvedAt) {
            this.resolvedAt = resolvedAt;
            return this;
        }

        public final String getResolvedReason() {
            return this.resolvedReason;
        }

        public final void setResolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
        }

        @Override
        public final Builder resolvedReason(String resolvedReason) {
            this.resolvedReason = resolvedReason;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BlockerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlockerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SyncBlocker build() {
            return new SyncBlocker(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyncBlocker> {
        public Builder contexts(Collection<SyncBlockerContext> var1);

        public Builder contexts(SyncBlockerContext ... var1);

        public Builder contexts(Consumer<SyncBlockerContext.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder createdReason(String var1);

        public Builder id(String var1);

        public Builder resolvedAt(Instant var1);

        public Builder resolvedReason(String var1);

        public Builder status(String var1);

        public Builder status(BlockerStatus var1);

        public Builder type(String var1);

        public Builder type(BlockerType var1);
    }
}

