/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed data about the current state of the deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentState implements SdkPojo, Serializable, ToCopyableBuilder<DeploymentState.Builder, DeploymentState> {
    private static final SdkField<ComponentState> COMPONENT_FIELD = SdkField.<ComponentState> builder(MarshallingType.SDK_POJO)
            .memberName("component").getter(getter(DeploymentState::component)).setter(setter(Builder::component))
            .constructor(ComponentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("component").build()).build();

    private static final SdkField<EnvironmentState> ENVIRONMENT_FIELD = SdkField
            .<EnvironmentState> builder(MarshallingType.SDK_POJO).memberName("environment")
            .getter(getter(DeploymentState::environment)).setter(setter(Builder::environment))
            .constructor(EnvironmentState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()).build();

    private static final SdkField<ServiceInstanceState> SERVICE_INSTANCE_FIELD = SdkField
            .<ServiceInstanceState> builder(MarshallingType.SDK_POJO).memberName("serviceInstance")
            .getter(getter(DeploymentState::serviceInstance)).setter(setter(Builder::serviceInstance))
            .constructor(ServiceInstanceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceInstance").build()).build();

    private static final SdkField<ServicePipelineState> SERVICE_PIPELINE_FIELD = SdkField
            .<ServicePipelineState> builder(MarshallingType.SDK_POJO).memberName("servicePipeline")
            .getter(getter(DeploymentState::servicePipeline)).setter(setter(Builder::servicePipeline))
            .constructor(ServicePipelineState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servicePipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_FIELD,
            ENVIRONMENT_FIELD, SERVICE_INSTANCE_FIELD, SERVICE_PIPELINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ComponentState component;

    private final EnvironmentState environment;

    private final ServiceInstanceState serviceInstance;

    private final ServicePipelineState servicePipeline;

    private final Type type;

    private DeploymentState(BuilderImpl builder) {
        this.component = builder.component;
        this.environment = builder.environment;
        this.serviceInstance = builder.serviceInstance;
        this.servicePipeline = builder.servicePipeline;
        this.type = builder.type;
    }

    /**
     * <p>
     * The state of the component associated with the deployment.
     * </p>
     * 
     * @return The state of the component associated with the deployment.
     */
    public final ComponentState component() {
        return component;
    }

    /**
     * <p>
     * The state of the environment associated with the deployment.
     * </p>
     * 
     * @return The state of the environment associated with the deployment.
     */
    public final EnvironmentState environment() {
        return environment;
    }

    /**
     * <p>
     * The state of the service instance associated with the deployment.
     * </p>
     * 
     * @return The state of the service instance associated with the deployment.
     */
    public final ServiceInstanceState serviceInstance() {
        return serviceInstance;
    }

    /**
     * <p>
     * The state of the service pipeline associated with the deployment.
     * </p>
     * 
     * @return The state of the service pipeline associated with the deployment.
     */
    public final ServicePipelineState servicePipeline() {
        return servicePipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(component());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(serviceInstance());
        hashCode = 31 * hashCode + Objects.hashCode(servicePipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentState)) {
            return false;
        }
        DeploymentState other = (DeploymentState) obj;
        return Objects.equals(component(), other.component()) && Objects.equals(environment(), other.environment())
                && Objects.equals(serviceInstance(), other.serviceInstance())
                && Objects.equals(servicePipeline(), other.servicePipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentState").add("Component", component()).add("Environment", environment())
                .add("ServiceInstance", serviceInstance()).add("ServicePipeline", servicePipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "component":
            return Optional.ofNullable(clazz.cast(component()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "serviceInstance":
            return Optional.ofNullable(clazz.cast(serviceInstance()));
        case "servicePipeline":
            return Optional.ofNullable(clazz.cast(servicePipeline()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #component()} initialized to the given value.
     *
     * <p>
     * The state of the component associated with the deployment.
     * </p>
     * 
     * @param component
     *        The state of the component associated with the deployment.
     */
    public static DeploymentState fromComponent(ComponentState component) {
        return builder().component(component).build();
    }

    /**
     * Create an instance of this class with {@link #component()} initialized to the given value.
     *
     * <p>
     * The state of the component associated with the deployment.
     * </p>
     * 
     * @param component
     *        The state of the component associated with the deployment.
     */
    public static DeploymentState fromComponent(Consumer<ComponentState.Builder> component) {
        ComponentState.Builder builder = ComponentState.builder();
        component.accept(builder);
        return fromComponent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #environment()} initialized to the given value.
     *
     * <p>
     * The state of the environment associated with the deployment.
     * </p>
     * 
     * @param environment
     *        The state of the environment associated with the deployment.
     */
    public static DeploymentState fromEnvironment(EnvironmentState environment) {
        return builder().environment(environment).build();
    }

    /**
     * Create an instance of this class with {@link #environment()} initialized to the given value.
     *
     * <p>
     * The state of the environment associated with the deployment.
     * </p>
     * 
     * @param environment
     *        The state of the environment associated with the deployment.
     */
    public static DeploymentState fromEnvironment(Consumer<EnvironmentState.Builder> environment) {
        EnvironmentState.Builder builder = EnvironmentState.builder();
        environment.accept(builder);
        return fromEnvironment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #serviceInstance()} initialized to the given value.
     *
     * <p>
     * The state of the service instance associated with the deployment.
     * </p>
     * 
     * @param serviceInstance
     *        The state of the service instance associated with the deployment.
     */
    public static DeploymentState fromServiceInstance(ServiceInstanceState serviceInstance) {
        return builder().serviceInstance(serviceInstance).build();
    }

    /**
     * Create an instance of this class with {@link #serviceInstance()} initialized to the given value.
     *
     * <p>
     * The state of the service instance associated with the deployment.
     * </p>
     * 
     * @param serviceInstance
     *        The state of the service instance associated with the deployment.
     */
    public static DeploymentState fromServiceInstance(Consumer<ServiceInstanceState.Builder> serviceInstance) {
        ServiceInstanceState.Builder builder = ServiceInstanceState.builder();
        serviceInstance.accept(builder);
        return fromServiceInstance(builder.build());
    }

    /**
     * Create an instance of this class with {@link #servicePipeline()} initialized to the given value.
     *
     * <p>
     * The state of the service pipeline associated with the deployment.
     * </p>
     * 
     * @param servicePipeline
     *        The state of the service pipeline associated with the deployment.
     */
    public static DeploymentState fromServicePipeline(ServicePipelineState servicePipeline) {
        return builder().servicePipeline(servicePipeline).build();
    }

    /**
     * Create an instance of this class with {@link #servicePipeline()} initialized to the given value.
     *
     * <p>
     * The state of the service pipeline associated with the deployment.
     * </p>
     * 
     * @param servicePipeline
     *        The state of the service pipeline associated with the deployment.
     */
    public static DeploymentState fromServicePipeline(Consumer<ServicePipelineState.Builder> servicePipeline) {
        ServicePipelineState.Builder builder = ServicePipelineState.builder();
        servicePipeline.accept(builder);
        return fromServicePipeline(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentState, T> g) {
        return obj -> g.apply((DeploymentState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentState> {
        /**
         * <p>
         * The state of the component associated with the deployment.
         * </p>
         * 
         * @param component
         *        The state of the component associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder component(ComponentState component);

        /**
         * <p>
         * The state of the component associated with the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComponentState.Builder} avoiding the need
         * to create one manually via {@link ComponentState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComponentState.Builder#build()} is called immediately and its
         * result is passed to {@link #component(ComponentState)}.
         * 
         * @param component
         *        a consumer that will call methods on {@link ComponentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #component(ComponentState)
         */
        default Builder component(Consumer<ComponentState.Builder> component) {
            return component(ComponentState.builder().applyMutation(component).build());
        }

        /**
         * <p>
         * The state of the environment associated with the deployment.
         * </p>
         * 
         * @param environment
         *        The state of the environment associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentState environment);

        /**
         * <p>
         * The state of the environment associated with the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentState.Builder} avoiding the
         * need to create one manually via {@link EnvironmentState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentState.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(EnvironmentState)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link EnvironmentState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(EnvironmentState)
         */
        default Builder environment(Consumer<EnvironmentState.Builder> environment) {
            return environment(EnvironmentState.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The state of the service instance associated with the deployment.
         * </p>
         * 
         * @param serviceInstance
         *        The state of the service instance associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceInstance(ServiceInstanceState serviceInstance);

        /**
         * <p>
         * The state of the service instance associated with the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceInstanceState.Builder} avoiding
         * the need to create one manually via {@link ServiceInstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceInstanceState.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceInstance(ServiceInstanceState)}.
         * 
         * @param serviceInstance
         *        a consumer that will call methods on {@link ServiceInstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceInstance(ServiceInstanceState)
         */
        default Builder serviceInstance(Consumer<ServiceInstanceState.Builder> serviceInstance) {
            return serviceInstance(ServiceInstanceState.builder().applyMutation(serviceInstance).build());
        }

        /**
         * <p>
         * The state of the service pipeline associated with the deployment.
         * </p>
         * 
         * @param servicePipeline
         *        The state of the service pipeline associated with the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePipeline(ServicePipelineState servicePipeline);

        /**
         * <p>
         * The state of the service pipeline associated with the deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServicePipelineState.Builder} avoiding
         * the need to create one manually via {@link ServicePipelineState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServicePipelineState.Builder#build()} is called immediately and
         * its result is passed to {@link #servicePipeline(ServicePipelineState)}.
         * 
         * @param servicePipeline
         *        a consumer that will call methods on {@link ServicePipelineState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servicePipeline(ServicePipelineState)
         */
        default Builder servicePipeline(Consumer<ServicePipelineState.Builder> servicePipeline) {
            return servicePipeline(ServicePipelineState.builder().applyMutation(servicePipeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ComponentState component;

        private EnvironmentState environment;

        private ServiceInstanceState serviceInstance;

        private ServicePipelineState servicePipeline;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentState model) {
            component(model.component);
            environment(model.environment);
            serviceInstance(model.serviceInstance);
            servicePipeline(model.servicePipeline);
        }

        public final ComponentState.Builder getComponent() {
            return component != null ? component.toBuilder() : null;
        }

        public final void setComponent(ComponentState.BuilderImpl component) {
            Object oldValue = this.component;
            this.component = component != null ? component.build() : null;
            handleUnionValueChange(Type.COMPONENT, oldValue, this.component);
        }

        @Override
        public final Builder component(ComponentState component) {
            Object oldValue = this.component;
            this.component = component;
            handleUnionValueChange(Type.COMPONENT, oldValue, this.component);
            return this;
        }

        public final EnvironmentState.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(EnvironmentState.BuilderImpl environment) {
            Object oldValue = this.environment;
            this.environment = environment != null ? environment.build() : null;
            handleUnionValueChange(Type.ENVIRONMENT, oldValue, this.environment);
        }

        @Override
        public final Builder environment(EnvironmentState environment) {
            Object oldValue = this.environment;
            this.environment = environment;
            handleUnionValueChange(Type.ENVIRONMENT, oldValue, this.environment);
            return this;
        }

        public final ServiceInstanceState.Builder getServiceInstance() {
            return serviceInstance != null ? serviceInstance.toBuilder() : null;
        }

        public final void setServiceInstance(ServiceInstanceState.BuilderImpl serviceInstance) {
            Object oldValue = this.serviceInstance;
            this.serviceInstance = serviceInstance != null ? serviceInstance.build() : null;
            handleUnionValueChange(Type.SERVICE_INSTANCE, oldValue, this.serviceInstance);
        }

        @Override
        public final Builder serviceInstance(ServiceInstanceState serviceInstance) {
            Object oldValue = this.serviceInstance;
            this.serviceInstance = serviceInstance;
            handleUnionValueChange(Type.SERVICE_INSTANCE, oldValue, this.serviceInstance);
            return this;
        }

        public final ServicePipelineState.Builder getServicePipeline() {
            return servicePipeline != null ? servicePipeline.toBuilder() : null;
        }

        public final void setServicePipeline(ServicePipelineState.BuilderImpl servicePipeline) {
            Object oldValue = this.servicePipeline;
            this.servicePipeline = servicePipeline != null ? servicePipeline.build() : null;
            handleUnionValueChange(Type.SERVICE_PIPELINE, oldValue, this.servicePipeline);
        }

        @Override
        public final Builder servicePipeline(ServicePipelineState servicePipeline) {
            Object oldValue = this.servicePipeline;
            this.servicePipeline = servicePipeline;
            handleUnionValueChange(Type.SERVICE_PIPELINE, oldValue, this.servicePipeline);
            return this;
        }

        @Override
        public DeploymentState build() {
            return new DeploymentState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DeploymentState#type()
     */
    public enum Type {
        COMPONENT,

        ENVIRONMENT,

        SERVICE_INSTANCE,

        SERVICE_PIPELINE,

        UNKNOWN_TO_SDK_VERSION
    }
}
