/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsRequest;
import software.amazon.awssdk.services.proton.model.ListComponentOutputsResponse;
import software.amazon.awssdk.services.proton.model.Output;

public class ListComponentOutputsIterable
implements SdkIterable<ListComponentOutputsResponse> {
    private final ProtonClient client;
    private final ListComponentOutputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentOutputsIterable(ProtonClient client, ListComponentOutputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListComponentOutputsResponseFetcher();
    }

    public Iterator<ListComponentOutputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Output> outputs() {
        Function<ListComponentOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.outputs() != null) {
                return response.outputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComponentOutputsResponseFetcher
    implements SyncPageFetcher<ListComponentOutputsResponse> {
        private ListComponentOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentOutputsResponse nextPage(ListComponentOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentOutputsIterable.this.client.listComponentOutputs(ListComponentOutputsIterable.this.firstRequest);
            }
            return ListComponentOutputsIterable.this.client.listComponentOutputs((ListComponentOutputsRequest)((Object)ListComponentOutputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

