/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListServiceTemplateVersionsResponse;
import software.amazon.awssdk.services.proton.model.ServiceTemplateVersionSummary;

public class ListServiceTemplateVersionsIterable
implements SdkIterable<ListServiceTemplateVersionsResponse> {
    private final ProtonClient client;
    private final ListServiceTemplateVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceTemplateVersionsIterable(ProtonClient client, ListServiceTemplateVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServiceTemplateVersionsResponseFetcher();
    }

    public Iterator<ListServiceTemplateVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceTemplateVersionSummary> templateVersions() {
        Function<ListServiceTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateVersions() != null) {
                return response.templateVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceTemplateVersionsResponseFetcher
    implements SyncPageFetcher<ListServiceTemplateVersionsResponse> {
        private ListServiceTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceTemplateVersionsResponse nextPage(ListServiceTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceTemplateVersionsIterable.this.client.listServiceTemplateVersions(ListServiceTemplateVersionsIterable.this.firstRequest);
            }
            return ListServiceTemplateVersionsIterable.this.client.listServiceTemplateVersions((ListServiceTemplateVersionsRequest)((Object)ListServiceTemplateVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

