/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompatibleEnvironmentTemplateInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompatibleEnvironmentTemplateInput> {
    private static final SdkField<String> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("majorVersion").getter(CompatibleEnvironmentTemplateInput.getter(CompatibleEnvironmentTemplateInput::majorVersion)).setter(CompatibleEnvironmentTemplateInput.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("majorVersion").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateName").getter(CompatibleEnvironmentTemplateInput.getter(CompatibleEnvironmentTemplateInput::templateName)).setter(CompatibleEnvironmentTemplateInput.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAJOR_VERSION_FIELD, TEMPLATE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String majorVersion;
    private final String templateName;

    private CompatibleEnvironmentTemplateInput(BuilderImpl builder) {
        this.majorVersion = builder.majorVersion;
        this.templateName = builder.templateName;
    }

    public final String majorVersion() {
        return this.majorVersion;
    }

    public final String templateName() {
        return this.templateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleEnvironmentTemplateInput)) {
            return false;
        }
        CompatibleEnvironmentTemplateInput other = (CompatibleEnvironmentTemplateInput)obj;
        return Objects.equals(this.majorVersion(), other.majorVersion()) && Objects.equals(this.templateName(), other.templateName());
    }

    public final String toString() {
        return ToString.builder((String)"CompatibleEnvironmentTemplateInput").add("MajorVersion", (Object)this.majorVersion()).add("TemplateName", (Object)this.templateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "majorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
            case "templateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompatibleEnvironmentTemplateInput, T> g) {
        return obj -> g.apply((CompatibleEnvironmentTemplateInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String majorVersion;
        private String templateName;

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleEnvironmentTemplateInput model) {
            this.majorVersion(model.majorVersion);
            this.templateName(model.templateName);
        }

        public final String getMajorVersion() {
            return this.majorVersion;
        }

        public final void setMajorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(String majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public CompatibleEnvironmentTemplateInput build() {
            return new CompatibleEnvironmentTemplateInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompatibleEnvironmentTemplateInput> {
        public Builder majorVersion(String var1);

        public Builder templateName(String var1);
    }
}

