/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesResponse;
import software.amazon.awssdk.services.proton.model.ProvisionedResource;

public class ListEnvironmentProvisionedResourcesPublisher
implements SdkPublisher<ListEnvironmentProvisionedResourcesResponse> {
    private final ProtonAsyncClient client;
    private final ListEnvironmentProvisionedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentProvisionedResourcesPublisher(ProtonAsyncClient client, ListEnvironmentProvisionedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentProvisionedResourcesPublisher(ProtonAsyncClient client, ListEnvironmentProvisionedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentProvisionedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentProvisionedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisionedResource> provisionedResources() {
        Function<ListEnvironmentProvisionedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.provisionedResources() != null) {
                return response.provisionedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentProvisionedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentProvisionedResourcesResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentProvisionedResourcesResponse> {
        private ListEnvironmentProvisionedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentProvisionedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentProvisionedResourcesResponse> nextPage(ListEnvironmentProvisionedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentProvisionedResourcesPublisher.this.client.listEnvironmentProvisionedResources(ListEnvironmentProvisionedResourcesPublisher.this.firstRequest);
            }
            return ListEnvironmentProvisionedResourcesPublisher.this.client.listEnvironmentProvisionedResources((ListEnvironmentProvisionedResourcesRequest)((Object)ListEnvironmentProvisionedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

