/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest;
import software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse;
import software.amazon.awssdk.services.proton.model.RepositorySyncDefinition;

public class ListRepositorySyncDefinitionsPublisher
implements SdkPublisher<ListRepositorySyncDefinitionsResponse> {
    private final ProtonAsyncClient client;
    private final ListRepositorySyncDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRepositorySyncDefinitionsPublisher(ProtonAsyncClient client, ListRepositorySyncDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRepositorySyncDefinitionsPublisher(ProtonAsyncClient client, ListRepositorySyncDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRepositorySyncDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRepositorySyncDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RepositorySyncDefinition> syncDefinitions() {
        Function<ListRepositorySyncDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.syncDefinitions() != null) {
                return response.syncDefinitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRepositorySyncDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRepositorySyncDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListRepositorySyncDefinitionsResponse> {
        private ListRepositorySyncDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositorySyncDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRepositorySyncDefinitionsResponse> nextPage(ListRepositorySyncDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListRepositorySyncDefinitionsPublisher.this.client.listRepositorySyncDefinitions(ListRepositorySyncDefinitionsPublisher.this.firstRequest);
            }
            return ListRepositorySyncDefinitionsPublisher.this.client.listRepositorySyncDefinitions((ListRepositorySyncDefinitionsRequest)((Object)ListRepositorySyncDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

