/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse;

public class ListEnvironmentTemplateVersionsPublisher
implements SdkPublisher<ListEnvironmentTemplateVersionsResponse> {
    private final ProtonAsyncClient client;
    private final ListEnvironmentTemplateVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentTemplateVersionsPublisher(ProtonAsyncClient client, ListEnvironmentTemplateVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentTemplateVersionsPublisher(ProtonAsyncClient client, ListEnvironmentTemplateVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentTemplateVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentTemplateVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentTemplateVersionSummary> templateVersions() {
        Function<ListEnvironmentTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateVersions() != null) {
                return response.templateVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentTemplateVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentTemplateVersionsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentTemplateVersionsResponse> {
        private ListEnvironmentTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentTemplateVersionsResponse> nextPage(ListEnvironmentTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentTemplateVersionsPublisher.this.client.listEnvironmentTemplateVersions(ListEnvironmentTemplateVersionsPublisher.this.firstRequest);
            }
            return ListEnvironmentTemplateVersionsPublisher.this.client.listEnvironmentTemplateVersions((ListEnvironmentTemplateVersionsRequest)((Object)ListEnvironmentTemplateVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

