/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest;
import software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse;
import software.amazon.awssdk.services.proton.model.ServiceInstanceSummary;

public class ListServiceInstancesIterable
implements SdkIterable<ListServiceInstancesResponse> {
    private final ProtonClient client;
    private final ListServiceInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceInstancesIterable(ProtonClient client, ListServiceInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServiceInstancesResponseFetcher();
    }

    public Iterator<ListServiceInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceInstanceSummary> serviceInstances() {
        Function<ListServiceInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceInstances() != null) {
                return response.serviceInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceInstancesResponseFetcher
    implements SyncPageFetcher<ListServiceInstancesResponse> {
        private ListServiceInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceInstancesResponse nextPage(ListServiceInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceInstancesIterable.this.client.listServiceInstances(ListServiceInstancesIterable.this.firstRequest);
            }
            return ListServiceInstancesIterable.this.client.listServiceInstances((ListServiceInstancesRequest)((Object)ListServiceInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

