/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.Provisioning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(EnvironmentTemplate.getter(EnvironmentTemplate::arn)).setter(EnvironmentTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentTemplate.getter(EnvironmentTemplate::createdAt)).setter(EnvironmentTemplate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EnvironmentTemplate.getter(EnvironmentTemplate::description)).setter(EnvironmentTemplate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(EnvironmentTemplate.getter(EnvironmentTemplate::displayName)).setter(EnvironmentTemplate.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(EnvironmentTemplate.getter(EnvironmentTemplate::encryptionKey)).setter(EnvironmentTemplate.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(EnvironmentTemplate.getter(EnvironmentTemplate::lastModifiedAt)).setter(EnvironmentTemplate.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EnvironmentTemplate.getter(EnvironmentTemplate::name)).setter(EnvironmentTemplate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVISIONING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioning").getter(EnvironmentTemplate.getter(EnvironmentTemplate::provisioningAsString)).setter(EnvironmentTemplate.setter(Builder::provisioning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioning").build()}).build();
    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedVersion").getter(EnvironmentTemplate.getter(EnvironmentTemplate::recommendedVersion)).setter(EnvironmentTemplate.setter(Builder::recommendedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ENCRYPTION_KEY_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, PROVISIONING_FIELD, RECOMMENDED_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String description;
    private final String displayName;
    private final String encryptionKey;
    private final Instant lastModifiedAt;
    private final String name;
    private final String provisioning;
    private final String recommendedVersion;

    private EnvironmentTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.encryptionKey = builder.encryptionKey;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.provisioning = builder.provisioning;
        this.recommendedVersion = builder.recommendedVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String name() {
        return this.name;
    }

    public final Provisioning provisioning() {
        return Provisioning.fromValue(this.provisioning);
    }

    public final String provisioningAsString() {
        return this.provisioning;
    }

    public final String recommendedVersion() {
        return this.recommendedVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentTemplate)) {
            return false;
        }
        EnvironmentTemplate other = (EnvironmentTemplate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provisioningAsString(), other.provisioningAsString()) && Objects.equals(this.recommendedVersion(), other.recommendedVersion());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentTemplate").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("EncryptionKey", (Object)this.encryptionKey()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("Name", (Object)this.name()).add("Provisioning", (Object)this.provisioningAsString()).add("RecommendedVersion", (Object)this.recommendedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provisioning": {
                return Optional.ofNullable(clazz.cast(this.provisioningAsString()));
            }
            case "recommendedVersion": {
                return Optional.ofNullable(clazz.cast(this.recommendedVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentTemplate, T> g) {
        return obj -> g.apply((EnvironmentTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String description;
        private String displayName;
        private String encryptionKey;
        private Instant lastModifiedAt;
        private String name;
        private String provisioning;
        private String recommendedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentTemplate model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.displayName(model.displayName);
            this.encryptionKey(model.encryptionKey);
            this.lastModifiedAt(model.lastModifiedAt);
            this.name(model.name);
            this.provisioning(model.provisioning);
            this.recommendedVersion(model.recommendedVersion);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        @Transient
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioning() {
            return this.provisioning;
        }

        public final void setProvisioning(String provisioning) {
            this.provisioning = provisioning;
        }

        @Override
        @Transient
        public final Builder provisioning(String provisioning) {
            this.provisioning = provisioning;
            return this;
        }

        @Override
        @Transient
        public final Builder provisioning(Provisioning provisioning) {
            this.provisioning(provisioning == null ? null : provisioning.toString());
            return this;
        }

        public final String getRecommendedVersion() {
            return this.recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        @Transient
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        public EnvironmentTemplate build() {
            return new EnvironmentTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentTemplate> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder encryptionKey(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder name(String var1);

        public Builder provisioning(String var1);

        public Builder provisioning(Provisioning var1);

        public Builder recommendedVersion(String var1);
    }
}

