/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.proton.ProtonAsyncClient;
import software.amazon.awssdk.services.proton.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceInstanceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceRequest;
import software.amazon.awssdk.services.proton.model.GetServiceResponse;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionRequest;
import software.amazon.awssdk.services.proton.model.GetServiceTemplateVersionResponse;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.waiters.ProtonAsyncWaiter;
import software.amazon.awssdk.services.proton.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultProtonAsyncWaiter
implements ProtonAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final ProtonAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetEnvironmentResponse> environmentDeployedWaiter;
    private final AsyncWaiter<GetEnvironmentTemplateVersionResponse> environmentTemplateVersionRegisteredWaiter;
    private final AsyncWaiter<GetServiceResponse> serviceCreatedWaiter;
    private final AsyncWaiter<GetServiceResponse> serviceDeletedWaiter;
    private final AsyncWaiter<GetServiceInstanceResponse> serviceInstanceDeployedWaiter;
    private final AsyncWaiter<GetServiceResponse> servicePipelineDeployedWaiter;
    private final AsyncWaiter<GetServiceTemplateVersionResponse> serviceTemplateVersionRegisteredWaiter;
    private final AsyncWaiter<GetServiceResponse> serviceUpdatedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultProtonAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ProtonAsyncClient)ProtonAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.environmentDeployedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetEnvironmentResponse.class).acceptors(DefaultProtonAsyncWaiter.environmentDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.environmentDeployedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.environmentTemplateVersionRegisteredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetEnvironmentTemplateVersionResponse.class).acceptors(DefaultProtonAsyncWaiter.environmentTemplateVersionRegisteredWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.environmentTemplateVersionRegisteredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.serviceCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetServiceResponse.class).acceptors(DefaultProtonAsyncWaiter.serviceCreatedWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.serviceCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.serviceDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetServiceResponse.class).acceptors(DefaultProtonAsyncWaiter.serviceDeletedWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.serviceDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.serviceInstanceDeployedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetServiceInstanceResponse.class).acceptors(DefaultProtonAsyncWaiter.serviceInstanceDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.serviceInstanceDeployedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.servicePipelineDeployedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetServiceResponse.class).acceptors(DefaultProtonAsyncWaiter.servicePipelineDeployedWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.servicePipelineDeployedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.serviceTemplateVersionRegisteredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetServiceTemplateVersionResponse.class).acceptors(DefaultProtonAsyncWaiter.serviceTemplateVersionRegisteredWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.serviceTemplateVersionRegisteredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.serviceUpdatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetServiceResponse.class).acceptors(DefaultProtonAsyncWaiter.serviceUpdatedWaiterAcceptors())).overrideConfiguration(DefaultProtonAsyncWaiter.serviceUpdatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentDeployed(GetEnvironmentRequest getEnvironmentRequest) {
        return this.environmentDeployedWaiter.runAsync(() -> this.client.getEnvironment(this.applyWaitersUserAgent(getEnvironmentRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentDeployed(GetEnvironmentRequest getEnvironmentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentDeployedWaiter.runAsync(() -> this.client.getEnvironment(this.applyWaitersUserAgent(getEnvironmentRequest)), DefaultProtonAsyncWaiter.environmentDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetEnvironmentTemplateVersionResponse>> waitUntilEnvironmentTemplateVersionRegistered(GetEnvironmentTemplateVersionRequest getEnvironmentTemplateVersionRequest) {
        return this.environmentTemplateVersionRegisteredWaiter.runAsync(() -> this.client.getEnvironmentTemplateVersion(this.applyWaitersUserAgent(getEnvironmentTemplateVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetEnvironmentTemplateVersionResponse>> waitUntilEnvironmentTemplateVersionRegistered(GetEnvironmentTemplateVersionRequest getEnvironmentTemplateVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentTemplateVersionRegisteredWaiter.runAsync(() -> this.client.getEnvironmentTemplateVersion(this.applyWaitersUserAgent(getEnvironmentTemplateVersionRequest)), DefaultProtonAsyncWaiter.environmentTemplateVersionRegisteredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServiceCreated(GetServiceRequest getServiceRequest) {
        return this.serviceCreatedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServiceCreated(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceCreatedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonAsyncWaiter.serviceCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServiceDeleted(GetServiceRequest getServiceRequest) {
        return this.serviceDeletedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServiceDeleted(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceDeletedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonAsyncWaiter.serviceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceInstanceResponse>> waitUntilServiceInstanceDeployed(GetServiceInstanceRequest getServiceInstanceRequest) {
        return this.serviceInstanceDeployedWaiter.runAsync(() -> this.client.getServiceInstance(this.applyWaitersUserAgent(getServiceInstanceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceInstanceResponse>> waitUntilServiceInstanceDeployed(GetServiceInstanceRequest getServiceInstanceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceInstanceDeployedWaiter.runAsync(() -> this.client.getServiceInstance(this.applyWaitersUserAgent(getServiceInstanceRequest)), DefaultProtonAsyncWaiter.serviceInstanceDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServicePipelineDeployed(GetServiceRequest getServiceRequest) {
        return this.servicePipelineDeployedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServicePipelineDeployed(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.servicePipelineDeployedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonAsyncWaiter.servicePipelineDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceTemplateVersionResponse>> waitUntilServiceTemplateVersionRegistered(GetServiceTemplateVersionRequest getServiceTemplateVersionRequest) {
        return this.serviceTemplateVersionRegisteredWaiter.runAsync(() -> this.client.getServiceTemplateVersion(this.applyWaitersUserAgent(getServiceTemplateVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceTemplateVersionResponse>> waitUntilServiceTemplateVersionRegistered(GetServiceTemplateVersionRequest getServiceTemplateVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceTemplateVersionRegisteredWaiter.runAsync(() -> this.client.getServiceTemplateVersion(this.applyWaitersUserAgent(getServiceTemplateVersionRequest)), DefaultProtonAsyncWaiter.serviceTemplateVersionRegisteredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServiceUpdated(GetServiceRequest getServiceRequest) {
        return this.serviceUpdatedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetServiceResponse>> waitUntilServiceUpdated(GetServiceRequest getServiceRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.serviceUpdatedWaiter.runAsync(() -> this.client.getService(this.applyWaitersUserAgent(getServiceRequest)), DefaultProtonAsyncWaiter.serviceUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetEnvironmentResponse>> environmentDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetEnvironmentResponse>> result = new ArrayList<WaiterAcceptor<? super GetEnvironmentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("environment").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("environment").field("deploymentStatus").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetEnvironmentTemplateVersionResponse>> environmentTemplateVersionRegisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetEnvironmentTemplateVersionResponse>> result = new ArrayList<WaiterAcceptor<? super GetEnvironmentTemplateVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("environmentTemplateVersion").field("status").value(), "DRAFT");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("environmentTemplateVersion").field("status").value(), "PUBLISHED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("environmentTemplateVersion").field("status").value(), "REGISTRATION_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> serviceCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "CREATE_FAILED_CLEANUP_COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "CREATE_FAILED_CLEANUP_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "CREATE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> serviceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultProtonAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "DELETE_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceInstanceResponse>> serviceInstanceDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceInstanceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceInstanceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("serviceInstance").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("serviceInstance").field("deploymentStatus").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> servicePipelineDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("pipeline").field("deploymentStatus").value(), "SUCCEEDED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("pipeline").field("deploymentStatus").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceTemplateVersionResponse>> serviceTemplateVersionRegisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceTemplateVersionResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceTemplateVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("serviceTemplateVersion").field("status").value(), "DRAFT");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("serviceTemplateVersion").field("status").value(), "PUBLISHED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("serviceTemplateVersion").field("status").value(), "REGISTRATION_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetServiceResponse>> serviceUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetServiceResponse>> result = new ArrayList<WaiterAcceptor<? super GetServiceResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_FAILED_CLEANUP_COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_FAILED_CLEANUP_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_FAILED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("service").field("status").value(), "UPDATE_COMPLETE_CLEANUP_FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration environmentDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentTemplateVersionRegisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceInstanceDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration servicePipelineDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceTemplateVersionRegisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(150);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration serviceUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(999);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ProtonAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ProtonRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ProtonRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ProtonAsyncWaiter.Builder {
        private ProtonAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public ProtonAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ProtonAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ProtonAsyncWaiter.Builder client(ProtonAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ProtonAsyncWaiter build() {
            return new DefaultProtonAsyncWaiter(this);
        }
    }
}

