/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.proton.model.ProtonRequest;
import software.amazon.awssdk.services.proton.model.RepositoryProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRepositoryRequest
extends ProtonRequest
implements ToCopyableBuilder<Builder, CreateRepositoryRequest> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionArn").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::connectionArn)).setter(CreateRepositoryRequest.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::encryptionKey)).setter(CreateRepositoryRequest.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::name)).setter(CreateRepositoryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(CreateRepositoryRequest.getter(CreateRepositoryRequest::providerAsString)).setter(CreateRepositoryRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, ENCRYPTION_KEY_FIELD, NAME_FIELD, PROVIDER_FIELD));
    private final String connectionArn;
    private final String encryptionKey;
    private final String name;
    private final String provider;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.encryptionKey = builder.encryptionKey;
        this.name = builder.name;
        this.provider = builder.provider;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final String name() {
        return this.name;
    }

    public final RepositoryProvider provider() {
        return RepositoryProvider.fromValue(this.provider);
    }

    public final String providerAsString() {
        return this.provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)((Object)obj);
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.providerAsString(), other.providerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRepositoryRequest").add("ConnectionArn", (Object)this.connectionArn()).add("EncryptionKey", (Object)this.encryptionKey()).add("Name", (Object)this.name()).add("Provider", (Object)this.providerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.providerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ProtonRequest.BuilderImpl
    implements Builder {
        private String connectionArn;
        private String encryptionKey;
        private String name;
        private String provider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            this.connectionArn(model.connectionArn);
            this.encryptionKey(model.encryptionKey);
            this.name(model.name);
            this.provider(model.provider);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        @Transient
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        @Transient
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        @Override
        @Transient
        public final Builder provider(RepositoryProvider provider) {
            this.provider(provider == null ? null : provider.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ProtonRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRepositoryRequest> {
        public Builder connectionArn(String var1);

        public Builder encryptionKey(String var1);

        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder provider(RepositoryProvider var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

