/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpccustomized;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocoljsonrpccustomized.model.ProtocolJsonRpcCustomizedException;
import software.amazon.awssdk.services.protocoljsonrpccustomized.model.SimpleRequest;
import software.amazon.awssdk.services.protocoljsonrpccustomized.model.SimpleResponse;

/**
 * Service client for accessing AmazonProtocolJsonRpcCustomized. This can be created using the static {@link #builder()}
 * method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolJsonRpcCustomizedClient extends SdkClient {
    String SERVICE_NAME = "jsonrpccustomized";

    /**
     * Create a {@link ProtocolJsonRpcCustomizedClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolJsonRpcCustomizedClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolJsonRpcCustomizedClient}.
     */
    static ProtocolJsonRpcCustomizedClientBuilder builder() {
        return new DefaultProtocolJsonRpcCustomizedClientBuilder();
    }

    /**
     * Invokes the Simple operation.
     *
     * @return Result of the Simple operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcCustomizedClient.Simple
     * @see #simple(SimpleRequest)
     */
    default SimpleResponse simple() throws AwsServiceException, SdkClientException, ProtocolJsonRpcCustomizedException {
        return simple(SimpleRequest.builder().build());
    }

    /**
     * Invokes the Simple operation.
     *
     * @param simpleRequest
     * @return Result of the Simple operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcCustomizedClient.Simple
     */
    default SimpleResponse simple(SimpleRequest simpleRequest) throws AwsServiceException, SdkClientException,
            ProtocolJsonRpcCustomizedException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the Simple operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SimpleRequest.Builder} avoiding the need to create
     * one manually via {@link SimpleRequest#builder()}
     * </p>
     *
     * @param simpleRequest
     *        A {@link Consumer} that will call methods on {@link SimpleStructure.Builder} to create a request.
     * @return Result of the Simple operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolJsonRpcCustomizedException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolJsonRpcCustomizedClient.Simple
     */
    default SimpleResponse simple(Consumer<SimpleRequest.Builder> simpleRequest) throws AwsServiceException, SdkClientException,
            ProtocolJsonRpcCustomizedException {
        return simple(SimpleRequest.builder().applyMutation(simpleRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("jsonrpccustomized");
    }
}
