/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.model;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.StandardMemberCopier;

@Generated("software.amazon.awssdk:codegen")
final class BlobMapTypeCopier {
    static Map<String, ByteBuffer> copy(Map<String, ByteBuffer> blobMapTypeParam) {
        if (blobMapTypeParam == null) {
            return null;
        }
        Map<String, ByteBuffer> blobMapTypeParamCopy = new HashMap<>(blobMapTypeParam.size());
        for (Map.Entry<String, ByteBuffer> e : blobMapTypeParam.entrySet()) {
            blobMapTypeParamCopy.put(StandardMemberCopier.copy(e.getKey()), StandardMemberCopier.copy(e.getValue()));
        }
        return Collections.unmodifiableMap(blobMapTypeParamCopy);
    }
}
