/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class QueryTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<QueryTypesResponse.Builder, QueryTypesResponse> {
    private final List<String> flattenedListOfStrings;

    private final List<String> nonFlattenedListWithLocation;

    private final List<SimpleStruct> flattenedListOfStructs;

    private final List<String> flattenedListWithLocation;

    private final Map<String, String> flattenedMap;

    private final Map<String, String> flattenedMapWithLocation;

    private final Map<String, String> nonFlattenedMapWithLocation;

    private QueryTypesResponse(BuilderImpl builder) {
        this.flattenedListOfStrings = builder.flattenedListOfStrings;
        this.nonFlattenedListWithLocation = builder.nonFlattenedListWithLocation;
        this.flattenedListOfStructs = builder.flattenedListOfStructs;
        this.flattenedListWithLocation = builder.flattenedListWithLocation;
        this.flattenedMap = builder.flattenedMap;
        this.flattenedMapWithLocation = builder.flattenedMapWithLocation;
        this.nonFlattenedMapWithLocation = builder.nonFlattenedMapWithLocation;
    }

    /**
     * Returns the value of the FlattenedListOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStrings property for this object.
     */
    public List<String> flattenedListOfStrings() {
        return flattenedListOfStrings;
    }

    /**
     * Returns the value of the NonFlattenedListWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the NonFlattenedListWithLocation property for this object.
     */
    public List<String> nonFlattenedListWithLocation() {
        return nonFlattenedListWithLocation;
    }

    /**
     * Returns the value of the FlattenedListOfStructs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStructs property for this object.
     */
    public List<SimpleStruct> flattenedListOfStructs() {
        return flattenedListOfStructs;
    }

    /**
     * Returns the value of the FlattenedListWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListWithLocation property for this object.
     */
    public List<String> flattenedListWithLocation() {
        return flattenedListWithLocation;
    }

    /**
     * Returns the value of the FlattenedMap property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedMap property for this object.
     */
    public Map<String, String> flattenedMap() {
        return flattenedMap;
    }

    /**
     * Returns the value of the FlattenedMapWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedMapWithLocation property for this object.
     */
    public Map<String, String> flattenedMapWithLocation() {
        return flattenedMapWithLocation;
    }

    /**
     * Returns the value of the NonFlattenedMapWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the NonFlattenedMapWithLocation property for this object.
     */
    public Map<String, String> nonFlattenedMapWithLocation() {
        return nonFlattenedMapWithLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((flattenedListOfStrings() == null) ? 0 : flattenedListOfStrings().hashCode());
        hashCode = 31 * hashCode + ((nonFlattenedListWithLocation() == null) ? 0 : nonFlattenedListWithLocation().hashCode());
        hashCode = 31 * hashCode + ((flattenedListOfStructs() == null) ? 0 : flattenedListOfStructs().hashCode());
        hashCode = 31 * hashCode + ((flattenedListWithLocation() == null) ? 0 : flattenedListWithLocation().hashCode());
        hashCode = 31 * hashCode + ((flattenedMap() == null) ? 0 : flattenedMap().hashCode());
        hashCode = 31 * hashCode + ((flattenedMapWithLocation() == null) ? 0 : flattenedMapWithLocation().hashCode());
        hashCode = 31 * hashCode + ((nonFlattenedMapWithLocation() == null) ? 0 : nonFlattenedMapWithLocation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryTypesResponse)) {
            return false;
        }
        QueryTypesResponse other = (QueryTypesResponse) obj;
        if (other.flattenedListOfStrings() == null ^ this.flattenedListOfStrings() == null) {
            return false;
        }
        if (other.flattenedListOfStrings() != null && !other.flattenedListOfStrings().equals(this.flattenedListOfStrings())) {
            return false;
        }
        if (other.nonFlattenedListWithLocation() == null ^ this.nonFlattenedListWithLocation() == null) {
            return false;
        }
        if (other.nonFlattenedListWithLocation() != null
                && !other.nonFlattenedListWithLocation().equals(this.nonFlattenedListWithLocation())) {
            return false;
        }
        if (other.flattenedListOfStructs() == null ^ this.flattenedListOfStructs() == null) {
            return false;
        }
        if (other.flattenedListOfStructs() != null && !other.flattenedListOfStructs().equals(this.flattenedListOfStructs())) {
            return false;
        }
        if (other.flattenedListWithLocation() == null ^ this.flattenedListWithLocation() == null) {
            return false;
        }
        if (other.flattenedListWithLocation() != null
                && !other.flattenedListWithLocation().equals(this.flattenedListWithLocation())) {
            return false;
        }
        if (other.flattenedMap() == null ^ this.flattenedMap() == null) {
            return false;
        }
        if (other.flattenedMap() != null && !other.flattenedMap().equals(this.flattenedMap())) {
            return false;
        }
        if (other.flattenedMapWithLocation() == null ^ this.flattenedMapWithLocation() == null) {
            return false;
        }
        if (other.flattenedMapWithLocation() != null && !other.flattenedMapWithLocation().equals(this.flattenedMapWithLocation())) {
            return false;
        }
        if (other.nonFlattenedMapWithLocation() == null ^ this.nonFlattenedMapWithLocation() == null) {
            return false;
        }
        if (other.nonFlattenedMapWithLocation() != null
                && !other.nonFlattenedMapWithLocation().equals(this.nonFlattenedMapWithLocation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (flattenedListOfStrings() != null) {
            sb.append("FlattenedListOfStrings: ").append(flattenedListOfStrings()).append(",");
        }
        if (nonFlattenedListWithLocation() != null) {
            sb.append("NonFlattenedListWithLocation: ").append(nonFlattenedListWithLocation()).append(",");
        }
        if (flattenedListOfStructs() != null) {
            sb.append("FlattenedListOfStructs: ").append(flattenedListOfStructs()).append(",");
        }
        if (flattenedListWithLocation() != null) {
            sb.append("FlattenedListWithLocation: ").append(flattenedListWithLocation()).append(",");
        }
        if (flattenedMap() != null) {
            sb.append("FlattenedMap: ").append(flattenedMap()).append(",");
        }
        if (flattenedMapWithLocation() != null) {
            sb.append("FlattenedMapWithLocation: ").append(flattenedMapWithLocation()).append(",");
        }
        if (nonFlattenedMapWithLocation() != null) {
            sb.append("NonFlattenedMapWithLocation: ").append(nonFlattenedMapWithLocation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, QueryTypesResponse> {
        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings);

        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(String... flattenedListOfStrings);

        /**
         * Sets the value of the NonFlattenedListWithLocation property for this object.
         *
         * @param nonFlattenedListWithLocation
         *        The new value for the NonFlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation);

        /**
         * Sets the value of the NonFlattenedListWithLocation property for this object.
         *
         * @param nonFlattenedListWithLocation
         *        The new value for the NonFlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedListWithLocation(String... nonFlattenedListWithLocation);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(String... flattenedListWithLocation);

        /**
         * Sets the value of the FlattenedMap property for this object.
         *
         * @param flattenedMap
         *        The new value for the FlattenedMap property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedMap(Map<String, String> flattenedMap);

        /**
         * Sets the value of the FlattenedMapWithLocation property for this object.
         *
         * @param flattenedMapWithLocation
         *        The new value for the FlattenedMapWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedMapWithLocation(Map<String, String> flattenedMapWithLocation);

        /**
         * Sets the value of the NonFlattenedMapWithLocation property for this object.
         *
         * @param nonFlattenedMapWithLocation
         *        The new value for the NonFlattenedMapWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> flattenedListOfStrings;

        private List<String> nonFlattenedListWithLocation;

        private List<SimpleStruct> flattenedListOfStructs;

        private List<String> flattenedListWithLocation;

        private Map<String, String> flattenedMap;

        private Map<String, String> flattenedMapWithLocation;

        private Map<String, String> nonFlattenedMapWithLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryTypesResponse model) {
            setFlattenedListOfStrings(model.flattenedListOfStrings);
            setNonFlattenedListWithLocation(model.nonFlattenedListWithLocation);
            setFlattenedListOfStructs(model.flattenedListOfStructs);
            setFlattenedListWithLocation(model.flattenedListWithLocation);
            setFlattenedMap(model.flattenedMap);
            setFlattenedMapWithLocation(model.flattenedMapWithLocation);
            setNonFlattenedMapWithLocation(model.nonFlattenedMapWithLocation);
        }

        public final Collection<String> getFlattenedListOfStrings() {
            return flattenedListOfStrings;
        }

        @Override
        public final Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStrings(String... flattenedListOfStrings) {
            flattenedListOfStrings(Arrays.asList(flattenedListOfStrings));
            return this;
        }

        public final void setFlattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
        }

        @SafeVarargs
        public final void setFlattenedListOfStrings(String... flattenedListOfStrings) {
            flattenedListOfStrings(Arrays.asList(flattenedListOfStrings));
        }

        public final Collection<String> getNonFlattenedListWithLocation() {
            return nonFlattenedListWithLocation;
        }

        @Override
        public final Builder nonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation) {
            this.nonFlattenedListWithLocation = NonFlattenedListWithLocationCopier.copy(nonFlattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonFlattenedListWithLocation(String... nonFlattenedListWithLocation) {
            nonFlattenedListWithLocation(Arrays.asList(nonFlattenedListWithLocation));
            return this;
        }

        public final void setNonFlattenedListWithLocation(Collection<String> nonFlattenedListWithLocation) {
            this.nonFlattenedListWithLocation = NonFlattenedListWithLocationCopier.copy(nonFlattenedListWithLocation);
        }

        @SafeVarargs
        public final void setNonFlattenedListWithLocation(String... nonFlattenedListWithLocation) {
            nonFlattenedListWithLocation(Arrays.asList(nonFlattenedListWithLocation));
        }

        public final Collection<SimpleStruct> getFlattenedListOfStructs() {
            return flattenedListOfStructs;
        }

        @Override
        public final Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            flattenedListOfStructs(Arrays.asList(flattenedListOfStructs));
            return this;
        }

        public final void setFlattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
        }

        @SafeVarargs
        public final void setFlattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            flattenedListOfStructs(Arrays.asList(flattenedListOfStructs));
        }

        public final Collection<String> getFlattenedListWithLocation() {
            return flattenedListWithLocation;
        }

        @Override
        public final Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListWithLocation(String... flattenedListWithLocation) {
            flattenedListWithLocation(Arrays.asList(flattenedListWithLocation));
            return this;
        }

        public final void setFlattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
        }

        @SafeVarargs
        public final void setFlattenedListWithLocation(String... flattenedListWithLocation) {
            flattenedListWithLocation(Arrays.asList(flattenedListWithLocation));
        }

        public final Map<String, String> getFlattenedMap() {
            return flattenedMap;
        }

        @Override
        public final Builder flattenedMap(Map<String, String> flattenedMap) {
            this.flattenedMap = FlattenedMapCopier.copy(flattenedMap);
            return this;
        }

        public final void setFlattenedMap(Map<String, String> flattenedMap) {
            this.flattenedMap = FlattenedMapCopier.copy(flattenedMap);
        }

        public final Map<String, String> getFlattenedMapWithLocation() {
            return flattenedMapWithLocation;
        }

        @Override
        public final Builder flattenedMapWithLocation(Map<String, String> flattenedMapWithLocation) {
            this.flattenedMapWithLocation = FlattenedMapWithLocationCopier.copy(flattenedMapWithLocation);
            return this;
        }

        public final void setFlattenedMapWithLocation(Map<String, String> flattenedMapWithLocation) {
            this.flattenedMapWithLocation = FlattenedMapWithLocationCopier.copy(flattenedMapWithLocation);
        }

        public final Map<String, String> getNonFlattenedMapWithLocation() {
            return nonFlattenedMapWithLocation;
        }

        @Override
        public final Builder nonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation) {
            this.nonFlattenedMapWithLocation = NonFlattenedMapWithLocationCopier.copy(nonFlattenedMapWithLocation);
            return this;
        }

        public final void setNonFlattenedMapWithLocation(Map<String, String> nonFlattenedMapWithLocation) {
            this.nonFlattenedMapWithLocation = NonFlattenedMapWithLocationCopier.copy(nonFlattenedMapWithLocation);
        }

        @Override
        public QueryTypesResponse build() {
            return new QueryTypesResponse(this);
        }
    }
}
