/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Ec2TypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<Ec2TypesResponse.Builder, Ec2TypesResponse> {
    private final List<String> flattenedListOfStrings;

    private final List<SimpleStruct> flattenedListOfStructs;

    private final List<String> flattenedListWithLocation;

    private final String stringMemberWithLocation;

    private final String stringMemberWithQueryName;

    private final String stringMemberWithLocationAndQueryName;

    private final List<String> listMemberWithLocationAndQueryName;

    private final List<String> listMemberWithOnlyMemberLocation;

    private Ec2TypesResponse(BuilderImpl builder) {
        this.flattenedListOfStrings = builder.flattenedListOfStrings;
        this.flattenedListOfStructs = builder.flattenedListOfStructs;
        this.flattenedListWithLocation = builder.flattenedListWithLocation;
        this.stringMemberWithLocation = builder.stringMemberWithLocation;
        this.stringMemberWithQueryName = builder.stringMemberWithQueryName;
        this.stringMemberWithLocationAndQueryName = builder.stringMemberWithLocationAndQueryName;
        this.listMemberWithLocationAndQueryName = builder.listMemberWithLocationAndQueryName;
        this.listMemberWithOnlyMemberLocation = builder.listMemberWithOnlyMemberLocation;
    }

    /**
     * Returns the value of the FlattenedListOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStrings property for this object.
     */
    public List<String> flattenedListOfStrings() {
        return flattenedListOfStrings;
    }

    /**
     * Returns the value of the FlattenedListOfStructs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListOfStructs property for this object.
     */
    public List<SimpleStruct> flattenedListOfStructs() {
        return flattenedListOfStructs;
    }

    /**
     * Returns the value of the FlattenedListWithLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the FlattenedListWithLocation property for this object.
     */
    public List<String> flattenedListWithLocation() {
        return flattenedListWithLocation;
    }

    /**
     * Returns the value of the StringMemberWithLocation property for this object.
     * 
     * @return The value of the StringMemberWithLocation property for this object.
     */
    public String stringMemberWithLocation() {
        return stringMemberWithLocation;
    }

    /**
     * Returns the value of the StringMemberWithQueryName property for this object.
     * 
     * @return The value of the StringMemberWithQueryName property for this object.
     */
    public String stringMemberWithQueryName() {
        return stringMemberWithQueryName;
    }

    /**
     * Returns the value of the StringMemberWithLocationAndQueryName property for this object.
     * 
     * @return The value of the StringMemberWithLocationAndQueryName property for this object.
     */
    public String stringMemberWithLocationAndQueryName() {
        return stringMemberWithLocationAndQueryName;
    }

    /**
     * Returns the value of the ListMemberWithLocationAndQueryName property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListMemberWithLocationAndQueryName property for this object.
     */
    public List<String> listMemberWithLocationAndQueryName() {
        return listMemberWithLocationAndQueryName;
    }

    /**
     * Returns the value of the ListMemberWithOnlyMemberLocation property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListMemberWithOnlyMemberLocation property for this object.
     */
    public List<String> listMemberWithOnlyMemberLocation() {
        return listMemberWithOnlyMemberLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((flattenedListOfStrings() == null) ? 0 : flattenedListOfStrings().hashCode());
        hashCode = 31 * hashCode + ((flattenedListOfStructs() == null) ? 0 : flattenedListOfStructs().hashCode());
        hashCode = 31 * hashCode + ((flattenedListWithLocation() == null) ? 0 : flattenedListWithLocation().hashCode());
        hashCode = 31 * hashCode + ((stringMemberWithLocation() == null) ? 0 : stringMemberWithLocation().hashCode());
        hashCode = 31 * hashCode + ((stringMemberWithQueryName() == null) ? 0 : stringMemberWithQueryName().hashCode());
        hashCode = 31 * hashCode
                + ((stringMemberWithLocationAndQueryName() == null) ? 0 : stringMemberWithLocationAndQueryName().hashCode());
        hashCode = 31 * hashCode
                + ((listMemberWithLocationAndQueryName() == null) ? 0 : listMemberWithLocationAndQueryName().hashCode());
        hashCode = 31 * hashCode
                + ((listMemberWithOnlyMemberLocation() == null) ? 0 : listMemberWithOnlyMemberLocation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2TypesResponse)) {
            return false;
        }
        Ec2TypesResponse other = (Ec2TypesResponse) obj;
        if (other.flattenedListOfStrings() == null ^ this.flattenedListOfStrings() == null) {
            return false;
        }
        if (other.flattenedListOfStrings() != null && !other.flattenedListOfStrings().equals(this.flattenedListOfStrings())) {
            return false;
        }
        if (other.flattenedListOfStructs() == null ^ this.flattenedListOfStructs() == null) {
            return false;
        }
        if (other.flattenedListOfStructs() != null && !other.flattenedListOfStructs().equals(this.flattenedListOfStructs())) {
            return false;
        }
        if (other.flattenedListWithLocation() == null ^ this.flattenedListWithLocation() == null) {
            return false;
        }
        if (other.flattenedListWithLocation() != null
                && !other.flattenedListWithLocation().equals(this.flattenedListWithLocation())) {
            return false;
        }
        if (other.stringMemberWithLocation() == null ^ this.stringMemberWithLocation() == null) {
            return false;
        }
        if (other.stringMemberWithLocation() != null && !other.stringMemberWithLocation().equals(this.stringMemberWithLocation())) {
            return false;
        }
        if (other.stringMemberWithQueryName() == null ^ this.stringMemberWithQueryName() == null) {
            return false;
        }
        if (other.stringMemberWithQueryName() != null
                && !other.stringMemberWithQueryName().equals(this.stringMemberWithQueryName())) {
            return false;
        }
        if (other.stringMemberWithLocationAndQueryName() == null ^ this.stringMemberWithLocationAndQueryName() == null) {
            return false;
        }
        if (other.stringMemberWithLocationAndQueryName() != null
                && !other.stringMemberWithLocationAndQueryName().equals(this.stringMemberWithLocationAndQueryName())) {
            return false;
        }
        if (other.listMemberWithLocationAndQueryName() == null ^ this.listMemberWithLocationAndQueryName() == null) {
            return false;
        }
        if (other.listMemberWithLocationAndQueryName() != null
                && !other.listMemberWithLocationAndQueryName().equals(this.listMemberWithLocationAndQueryName())) {
            return false;
        }
        if (other.listMemberWithOnlyMemberLocation() == null ^ this.listMemberWithOnlyMemberLocation() == null) {
            return false;
        }
        if (other.listMemberWithOnlyMemberLocation() != null
                && !other.listMemberWithOnlyMemberLocation().equals(this.listMemberWithOnlyMemberLocation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (flattenedListOfStrings() != null) {
            sb.append("FlattenedListOfStrings: ").append(flattenedListOfStrings()).append(",");
        }
        if (flattenedListOfStructs() != null) {
            sb.append("FlattenedListOfStructs: ").append(flattenedListOfStructs()).append(",");
        }
        if (flattenedListWithLocation() != null) {
            sb.append("FlattenedListWithLocation: ").append(flattenedListWithLocation()).append(",");
        }
        if (stringMemberWithLocation() != null) {
            sb.append("StringMemberWithLocation: ").append(stringMemberWithLocation()).append(",");
        }
        if (stringMemberWithQueryName() != null) {
            sb.append("StringMemberWithQueryName: ").append(stringMemberWithQueryName()).append(",");
        }
        if (stringMemberWithLocationAndQueryName() != null) {
            sb.append("StringMemberWithLocationAndQueryName: ").append(stringMemberWithLocationAndQueryName()).append(",");
        }
        if (listMemberWithLocationAndQueryName() != null) {
            sb.append("ListMemberWithLocationAndQueryName: ").append(listMemberWithLocationAndQueryName()).append(",");
        }
        if (listMemberWithOnlyMemberLocation() != null) {
            sb.append("ListMemberWithOnlyMemberLocation: ").append(listMemberWithOnlyMemberLocation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Ec2TypesResponse> {
        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings);

        /**
         * Sets the value of the FlattenedListOfStrings property for this object.
         *
         * @param flattenedListOfStrings
         *        The new value for the FlattenedListOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStrings(String... flattenedListOfStrings);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListOfStructs property for this object.
         *
         * @param flattenedListOfStructs
         *        The new value for the FlattenedListOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation);

        /**
         * Sets the value of the FlattenedListWithLocation property for this object.
         *
         * @param flattenedListWithLocation
         *        The new value for the FlattenedListWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flattenedListWithLocation(String... flattenedListWithLocation);

        /**
         * Sets the value of the StringMemberWithLocation property for this object.
         *
         * @param stringMemberWithLocation
         *        The new value for the StringMemberWithLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithLocation(String stringMemberWithLocation);

        /**
         * Sets the value of the StringMemberWithQueryName property for this object.
         *
         * @param stringMemberWithQueryName
         *        The new value for the StringMemberWithQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithQueryName(String stringMemberWithQueryName);

        /**
         * Sets the value of the StringMemberWithLocationAndQueryName property for this object.
         *
         * @param stringMemberWithLocationAndQueryName
         *        The new value for the StringMemberWithLocationAndQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName);

        /**
         * Sets the value of the ListMemberWithLocationAndQueryName property for this object.
         *
         * @param listMemberWithLocationAndQueryName
         *        The new value for the ListMemberWithLocationAndQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName);

        /**
         * Sets the value of the ListMemberWithLocationAndQueryName property for this object.
         *
         * @param listMemberWithLocationAndQueryName
         *        The new value for the ListMemberWithLocationAndQueryName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName);

        /**
         * Sets the value of the ListMemberWithOnlyMemberLocation property for this object.
         *
         * @param listMemberWithOnlyMemberLocation
         *        The new value for the ListMemberWithOnlyMemberLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation);

        /**
         * Sets the value of the ListMemberWithOnlyMemberLocation property for this object.
         *
         * @param listMemberWithOnlyMemberLocation
         *        The new value for the ListMemberWithOnlyMemberLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> flattenedListOfStrings;

        private List<SimpleStruct> flattenedListOfStructs;

        private List<String> flattenedListWithLocation;

        private String stringMemberWithLocation;

        private String stringMemberWithQueryName;

        private String stringMemberWithLocationAndQueryName;

        private List<String> listMemberWithLocationAndQueryName;

        private List<String> listMemberWithOnlyMemberLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2TypesResponse model) {
            setFlattenedListOfStrings(model.flattenedListOfStrings);
            setFlattenedListOfStructs(model.flattenedListOfStructs);
            setFlattenedListWithLocation(model.flattenedListWithLocation);
            setStringMemberWithLocation(model.stringMemberWithLocation);
            setStringMemberWithQueryName(model.stringMemberWithQueryName);
            setStringMemberWithLocationAndQueryName(model.stringMemberWithLocationAndQueryName);
            setListMemberWithLocationAndQueryName(model.listMemberWithLocationAndQueryName);
            setListMemberWithOnlyMemberLocation(model.listMemberWithOnlyMemberLocation);
        }

        public final Collection<String> getFlattenedListOfStrings() {
            return flattenedListOfStrings;
        }

        @Override
        public final Builder flattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStrings(String... flattenedListOfStrings) {
            flattenedListOfStrings(Arrays.asList(flattenedListOfStrings));
            return this;
        }

        public final void setFlattenedListOfStrings(Collection<String> flattenedListOfStrings) {
            this.flattenedListOfStrings = FlattenedListOfStringsCopier.copy(flattenedListOfStrings);
        }

        @SafeVarargs
        public final void setFlattenedListOfStrings(String... flattenedListOfStrings) {
            flattenedListOfStrings(Arrays.asList(flattenedListOfStrings));
        }

        public final Collection<SimpleStruct> getFlattenedListOfStructs() {
            return flattenedListOfStructs;
        }

        @Override
        public final Builder flattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            flattenedListOfStructs(Arrays.asList(flattenedListOfStructs));
            return this;
        }

        public final void setFlattenedListOfStructs(Collection<SimpleStruct> flattenedListOfStructs) {
            this.flattenedListOfStructs = FlattenedListOfStructsCopier.copy(flattenedListOfStructs);
        }

        @SafeVarargs
        public final void setFlattenedListOfStructs(SimpleStruct... flattenedListOfStructs) {
            flattenedListOfStructs(Arrays.asList(flattenedListOfStructs));
        }

        public final Collection<String> getFlattenedListWithLocation() {
            return flattenedListWithLocation;
        }

        @Override
        public final Builder flattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flattenedListWithLocation(String... flattenedListWithLocation) {
            flattenedListWithLocation(Arrays.asList(flattenedListWithLocation));
            return this;
        }

        public final void setFlattenedListWithLocation(Collection<String> flattenedListWithLocation) {
            this.flattenedListWithLocation = FlattenedListWithLocationCopier.copy(flattenedListWithLocation);
        }

        @SafeVarargs
        public final void setFlattenedListWithLocation(String... flattenedListWithLocation) {
            flattenedListWithLocation(Arrays.asList(flattenedListWithLocation));
        }

        public final String getStringMemberWithLocation() {
            return stringMemberWithLocation;
        }

        @Override
        public final Builder stringMemberWithLocation(String stringMemberWithLocation) {
            this.stringMemberWithLocation = stringMemberWithLocation;
            return this;
        }

        public final void setStringMemberWithLocation(String stringMemberWithLocation) {
            this.stringMemberWithLocation = stringMemberWithLocation;
        }

        public final String getStringMemberWithQueryName() {
            return stringMemberWithQueryName;
        }

        @Override
        public final Builder stringMemberWithQueryName(String stringMemberWithQueryName) {
            this.stringMemberWithQueryName = stringMemberWithQueryName;
            return this;
        }

        public final void setStringMemberWithQueryName(String stringMemberWithQueryName) {
            this.stringMemberWithQueryName = stringMemberWithQueryName;
        }

        public final String getStringMemberWithLocationAndQueryName() {
            return stringMemberWithLocationAndQueryName;
        }

        @Override
        public final Builder stringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName) {
            this.stringMemberWithLocationAndQueryName = stringMemberWithLocationAndQueryName;
            return this;
        }

        public final void setStringMemberWithLocationAndQueryName(String stringMemberWithLocationAndQueryName) {
            this.stringMemberWithLocationAndQueryName = stringMemberWithLocationAndQueryName;
        }

        public final Collection<String> getListMemberWithLocationAndQueryName() {
            return listMemberWithLocationAndQueryName;
        }

        @Override
        public final Builder listMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName) {
            this.listMemberWithLocationAndQueryName = ListOfStringsCopier.copy(listMemberWithLocationAndQueryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName) {
            listMemberWithLocationAndQueryName(Arrays.asList(listMemberWithLocationAndQueryName));
            return this;
        }

        public final void setListMemberWithLocationAndQueryName(Collection<String> listMemberWithLocationAndQueryName) {
            this.listMemberWithLocationAndQueryName = ListOfStringsCopier.copy(listMemberWithLocationAndQueryName);
        }

        @SafeVarargs
        public final void setListMemberWithLocationAndQueryName(String... listMemberWithLocationAndQueryName) {
            listMemberWithLocationAndQueryName(Arrays.asList(listMemberWithLocationAndQueryName));
        }

        public final Collection<String> getListMemberWithOnlyMemberLocation() {
            return listMemberWithOnlyMemberLocation;
        }

        @Override
        public final Builder listMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation) {
            this.listMemberWithOnlyMemberLocation = ListOfStringsCopier.copy(listMemberWithOnlyMemberLocation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation) {
            listMemberWithOnlyMemberLocation(Arrays.asList(listMemberWithOnlyMemberLocation));
            return this;
        }

        public final void setListMemberWithOnlyMemberLocation(Collection<String> listMemberWithOnlyMemberLocation) {
            this.listMemberWithOnlyMemberLocation = ListOfStringsCopier.copy(listMemberWithOnlyMemberLocation);
        }

        @SafeVarargs
        public final void setListMemberWithOnlyMemberLocation(String... listMemberWithOnlyMemberLocation) {
            listMemberWithOnlyMemberLocation(Arrays.asList(listMemberWithOnlyMemberLocation));
        }

        @Override
        public Ec2TypesResponse build() {
            return new Ec2TypesResponse(this);
        }
    }
}
