/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * NoModeledExceptionsResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class NoModeledExceptionsResponseUnmarshaller implements
        Unmarshaller<NoModeledExceptionsResponse, JsonUnmarshallerContext> {

    public NoModeledExceptionsResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        NoModeledExceptionsResponse.Builder noModeledExceptionsResponseBuilder = NoModeledExceptionsResponse.builder();

        return noModeledExceptionsResponseBuilder.build();
    }

    private static NoModeledExceptionsResponseUnmarshaller INSTANCE;

    public static NoModeledExceptionsResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new NoModeledExceptionsResponseUnmarshaller();
        return INSTANCE;
    }
}
