/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AllTypesStructure JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AllTypesStructureUnmarshaller implements Unmarshaller<AllTypesStructure, JsonUnmarshallerContext> {

    public AllTypesStructure unmarshall(JsonUnmarshallerContext context) throws Exception {
        AllTypesStructure.Builder allTypesStructureBuilder = AllTypesStructure.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StringMember", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.stringMember(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IntegerMember", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.integerMember(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("NumberMember", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.numberMember(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("BooleanMember", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.booleanMember(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("NestedStructure", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.nestedStructure(StructureWithStringMemberUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("RecursiveStructure", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.recursiveStructure(RecursiveStructureUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ListOfStrings", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.listOfStrings(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("ListOfStructs", targetDepth)) {
                    context.nextToken();
                    allTypesStructureBuilder.listOfStructs(new ListUnmarshaller<StructureWithStringMember>(
                            StructureWithStringMemberUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return allTypesStructureBuilder.build();
    }

    private static AllTypesStructureUnmarshaller INSTANCE;

    public static AllTypesStructureUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new AllTypesStructureUnmarshaller();
        return INSTANCE;
    }
}
