/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MembersInHeadersRequest extends ProtocolRestXmlRequest implements
        ToCopyableBuilder<MembersInHeadersRequest.Builder, MembersInHeadersRequest> {
    private static final SdkField<String> STRING_MEMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MembersInHeadersRequest::stringMember))
            .setter(setter(Builder::stringMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-string")
                    .unmarshallLocationName("x-amz-string").build()).build();

    private static final SdkField<Boolean> BOOLEAN_MEMBER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(MembersInHeadersRequest::booleanMember))
            .setter(setter(Builder::booleanMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-boolean")
                    .unmarshallLocationName("x-amz-boolean").build()).build();

    private static final SdkField<Integer> INTEGER_MEMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MembersInHeadersRequest::integerMember))
            .setter(setter(Builder::integerMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-integer")
                    .unmarshallLocationName("x-amz-integer").build()).build();

    private static final SdkField<Long> LONG_MEMBER_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(MembersInHeadersRequest::longMember))
            .setter(setter(Builder::longMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-long")
                    .unmarshallLocationName("x-amz-long").build()).build();

    private static final SdkField<Float> FLOAT_MEMBER_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .getter(getter(MembersInHeadersRequest::floatMember))
            .setter(setter(Builder::floatMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-float")
                    .unmarshallLocationName("x-amz-float").build()).build();

    private static final SdkField<Double> DOUBLE_MEMBER_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(MembersInHeadersRequest::doubleMember))
            .setter(setter(Builder::doubleMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-double")
                    .unmarshallLocationName("x-amz-double").build()).build();

    private static final SdkField<Instant> TIMESTAMP_MEMBER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MembersInHeadersRequest::timestampMember))
            .setter(setter(Builder::timestampMember))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-timestamp")
                    .unmarshallLocationName("x-amz-timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_MEMBER_FIELD,
            BOOLEAN_MEMBER_FIELD, INTEGER_MEMBER_FIELD, LONG_MEMBER_FIELD, FLOAT_MEMBER_FIELD, DOUBLE_MEMBER_FIELD,
            TIMESTAMP_MEMBER_FIELD));

    private final String stringMember;

    private final Boolean booleanMember;

    private final Integer integerMember;

    private final Long longMember;

    private final Float floatMember;

    private final Double doubleMember;

    private final Instant timestampMember;

    private MembersInHeadersRequest(BuilderImpl builder) {
        super(builder);
        this.stringMember = builder.stringMember;
        this.booleanMember = builder.booleanMember;
        this.integerMember = builder.integerMember;
        this.longMember = builder.longMember;
        this.floatMember = builder.floatMember;
        this.doubleMember = builder.doubleMember;
        this.timestampMember = builder.timestampMember;
    }

    /**
     * Returns the value of the StringMember property for this object.
     * 
     * @return The value of the StringMember property for this object.
     */
    public String stringMember() {
        return stringMember;
    }

    /**
     * Returns the value of the BooleanMember property for this object.
     * 
     * @return The value of the BooleanMember property for this object.
     */
    public Boolean booleanMember() {
        return booleanMember;
    }

    /**
     * Returns the value of the IntegerMember property for this object.
     * 
     * @return The value of the IntegerMember property for this object.
     */
    public Integer integerMember() {
        return integerMember;
    }

    /**
     * Returns the value of the LongMember property for this object.
     * 
     * @return The value of the LongMember property for this object.
     */
    public Long longMember() {
        return longMember;
    }

    /**
     * Returns the value of the FloatMember property for this object.
     * 
     * @return The value of the FloatMember property for this object.
     */
    public Float floatMember() {
        return floatMember;
    }

    /**
     * Returns the value of the DoubleMember property for this object.
     * 
     * @return The value of the DoubleMember property for this object.
     */
    public Double doubleMember() {
        return doubleMember;
    }

    /**
     * Returns the value of the TimestampMember property for this object.
     * 
     * @return The value of the TimestampMember property for this object.
     */
    public Instant timestampMember() {
        return timestampMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringMember());
        hashCode = 31 * hashCode + Objects.hashCode(booleanMember());
        hashCode = 31 * hashCode + Objects.hashCode(integerMember());
        hashCode = 31 * hashCode + Objects.hashCode(longMember());
        hashCode = 31 * hashCode + Objects.hashCode(floatMember());
        hashCode = 31 * hashCode + Objects.hashCode(doubleMember());
        hashCode = 31 * hashCode + Objects.hashCode(timestampMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembersInHeadersRequest)) {
            return false;
        }
        MembersInHeadersRequest other = (MembersInHeadersRequest) obj;
        return Objects.equals(stringMember(), other.stringMember()) && Objects.equals(booleanMember(), other.booleanMember())
                && Objects.equals(integerMember(), other.integerMember()) && Objects.equals(longMember(), other.longMember())
                && Objects.equals(floatMember(), other.floatMember()) && Objects.equals(doubleMember(), other.doubleMember())
                && Objects.equals(timestampMember(), other.timestampMember());
    }

    @Override
    public String toString() {
        return ToString.builder("MembersInHeadersRequest").add("StringMember", stringMember())
                .add("BooleanMember", booleanMember()).add("IntegerMember", integerMember()).add("LongMember", longMember())
                .add("FloatMember", floatMember()).add("DoubleMember", doubleMember()).add("TimestampMember", timestampMember())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringMember":
            return Optional.ofNullable(clazz.cast(stringMember()));
        case "BooleanMember":
            return Optional.ofNullable(clazz.cast(booleanMember()));
        case "IntegerMember":
            return Optional.ofNullable(clazz.cast(integerMember()));
        case "LongMember":
            return Optional.ofNullable(clazz.cast(longMember()));
        case "FloatMember":
            return Optional.ofNullable(clazz.cast(floatMember()));
        case "DoubleMember":
            return Optional.ofNullable(clazz.cast(doubleMember()));
        case "TimestampMember":
            return Optional.ofNullable(clazz.cast(timestampMember()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MembersInHeadersRequest, T> g) {
        return obj -> g.apply((MembersInHeadersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolRestXmlRequest.Builder, SdkPojo, CopyableBuilder<Builder, MembersInHeadersRequest> {
        /**
         * Sets the value of the StringMember property for this object.
         *
         * @param stringMember
         *        The new value for the StringMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMember(String stringMember);

        /**
         * Sets the value of the BooleanMember property for this object.
         *
         * @param booleanMember
         *        The new value for the BooleanMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanMember(Boolean booleanMember);

        /**
         * Sets the value of the IntegerMember property for this object.
         *
         * @param integerMember
         *        The new value for the IntegerMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerMember(Integer integerMember);

        /**
         * Sets the value of the LongMember property for this object.
         *
         * @param longMember
         *        The new value for the LongMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longMember(Long longMember);

        /**
         * Sets the value of the FloatMember property for this object.
         *
         * @param floatMember
         *        The new value for the FloatMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatMember(Float floatMember);

        /**
         * Sets the value of the DoubleMember property for this object.
         *
         * @param doubleMember
         *        The new value for the DoubleMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleMember(Double doubleMember);

        /**
         * Sets the value of the TimestampMember property for this object.
         *
         * @param timestampMember
         *        The new value for the TimestampMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampMember(Instant timestampMember);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolRestXmlRequest.BuilderImpl implements Builder {
        private String stringMember;

        private Boolean booleanMember;

        private Integer integerMember;

        private Long longMember;

        private Float floatMember;

        private Double doubleMember;

        private Instant timestampMember;

        private BuilderImpl() {
        }

        private BuilderImpl(MembersInHeadersRequest model) {
            super(model);
            stringMember(model.stringMember);
            booleanMember(model.booleanMember);
            integerMember(model.integerMember);
            longMember(model.longMember);
            floatMember(model.floatMember);
            doubleMember(model.doubleMember);
            timestampMember(model.timestampMember);
        }

        public final String getStringMember() {
            return stringMember;
        }

        @Override
        public final Builder stringMember(String stringMember) {
            this.stringMember = stringMember;
            return this;
        }

        public final void setStringMember(String stringMember) {
            this.stringMember = stringMember;
        }

        public final Boolean getBooleanMember() {
            return booleanMember;
        }

        @Override
        public final Builder booleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
            return this;
        }

        public final void setBooleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
        }

        public final Integer getIntegerMember() {
            return integerMember;
        }

        @Override
        public final Builder integerMember(Integer integerMember) {
            this.integerMember = integerMember;
            return this;
        }

        public final void setIntegerMember(Integer integerMember) {
            this.integerMember = integerMember;
        }

        public final Long getLongMember() {
            return longMember;
        }

        @Override
        public final Builder longMember(Long longMember) {
            this.longMember = longMember;
            return this;
        }

        public final void setLongMember(Long longMember) {
            this.longMember = longMember;
        }

        public final Float getFloatMember() {
            return floatMember;
        }

        @Override
        public final Builder floatMember(Float floatMember) {
            this.floatMember = floatMember;
            return this;
        }

        public final void setFloatMember(Float floatMember) {
            this.floatMember = floatMember;
        }

        public final Double getDoubleMember() {
            return doubleMember;
        }

        @Override
        public final Builder doubleMember(Double doubleMember) {
            this.doubleMember = doubleMember;
            return this;
        }

        public final void setDoubleMember(Double doubleMember) {
            this.doubleMember = doubleMember;
        }

        public final Instant getTimestampMember() {
            return timestampMember;
        }

        @Override
        public final Builder timestampMember(Instant timestampMember) {
            this.timestampMember = timestampMember;
            return this;
        }

        public final void setTimestampMember(Instant timestampMember) {
            this.timestampMember = timestampMember;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MembersInHeadersRequest build() {
            return new MembersInHeadersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
