/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExplicitPayloadAndHeadersException extends ProtocolRestJsonException implements
        ToCopyableBuilder<ExplicitPayloadAndHeadersException.Builder, ExplicitPayloadAndHeadersException> {
    private static final SdkField<String> STRING_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ExplicitPayloadAndHeadersException::stringHeader)).setter(setter(Builder::stringHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-string").build()).build();

    private static final SdkField<Integer> INTEGER_HEADER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ExplicitPayloadAndHeadersException::integerHeader)).setter(setter(Builder::integerHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-integer").build()).build();

    private static final SdkField<Long> LONG_HEADER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ExplicitPayloadAndHeadersException::longHeader)).setter(setter(Builder::longHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-long").build()).build();

    private static final SdkField<Double> DOUBLE_HEADER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(ExplicitPayloadAndHeadersException::doubleHeader)).setter(setter(Builder::doubleHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-double").build()).build();

    private static final SdkField<Float> FLOAT_HEADER_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(ExplicitPayloadAndHeadersException::floatHeader)).setter(setter(Builder::floatHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-float").build()).build();

    private static final SdkField<Instant> TIMESTAMP_HEADER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ExplicitPayloadAndHeadersException::timestampHeader)).setter(setter(Builder::timestampHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-timestamp").build()).build();

    private static final SdkField<Boolean> BOOLEAN_HEADER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ExplicitPayloadAndHeadersException::booleanHeader)).setter(setter(Builder::booleanHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-boolean").build()).build();

    private static final SdkField<SimpleStruct> PAYLOAD_MEMBER_FIELD = SdkField
            .<SimpleStruct> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExplicitPayloadAndHeadersException::payloadMember))
            .setter(setter(Builder::payloadMember))
            .constructor(SimpleStruct::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadMember").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_HEADER_FIELD,
            INTEGER_HEADER_FIELD, LONG_HEADER_FIELD, DOUBLE_HEADER_FIELD, FLOAT_HEADER_FIELD, TIMESTAMP_HEADER_FIELD,
            BOOLEAN_HEADER_FIELD, PAYLOAD_MEMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringHeader;

    private final Integer integerHeader;

    private final Long longHeader;

    private final Double doubleHeader;

    private final Float floatHeader;

    private final Instant timestampHeader;

    private final Boolean booleanHeader;

    private final SimpleStruct payloadMember;

    private ExplicitPayloadAndHeadersException(BuilderImpl builder) {
        super(builder);
        this.stringHeader = builder.stringHeader;
        this.integerHeader = builder.integerHeader;
        this.longHeader = builder.longHeader;
        this.doubleHeader = builder.doubleHeader;
        this.floatHeader = builder.floatHeader;
        this.timestampHeader = builder.timestampHeader;
        this.booleanHeader = builder.booleanHeader;
        this.payloadMember = builder.payloadMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the StringHeader property for this object.
     * 
     * @return The value of the StringHeader property for this object.
     */
    public String stringHeader() {
        return stringHeader;
    }

    /**
     * Returns the value of the IntegerHeader property for this object.
     * 
     * @return The value of the IntegerHeader property for this object.
     */
    public Integer integerHeader() {
        return integerHeader;
    }

    /**
     * Returns the value of the LongHeader property for this object.
     * 
     * @return The value of the LongHeader property for this object.
     */
    public Long longHeader() {
        return longHeader;
    }

    /**
     * Returns the value of the DoubleHeader property for this object.
     * 
     * @return The value of the DoubleHeader property for this object.
     */
    public Double doubleHeader() {
        return doubleHeader;
    }

    /**
     * Returns the value of the FloatHeader property for this object.
     * 
     * @return The value of the FloatHeader property for this object.
     */
    public Float floatHeader() {
        return floatHeader;
    }

    /**
     * Returns the value of the TimestampHeader property for this object.
     * 
     * @return The value of the TimestampHeader property for this object.
     */
    public Instant timestampHeader() {
        return timestampHeader;
    }

    /**
     * Returns the value of the BooleanHeader property for this object.
     * 
     * @return The value of the BooleanHeader property for this object.
     */
    public Boolean booleanHeader() {
        return booleanHeader;
    }

    /**
     * Returns the value of the PayloadMember property for this object.
     * 
     * @return The value of the PayloadMember property for this object.
     */
    public SimpleStruct payloadMember() {
        return payloadMember;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExplicitPayloadAndHeadersException, T> g) {
        return obj -> g.apply((ExplicitPayloadAndHeadersException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExplicitPayloadAndHeadersException>,
            ProtocolRestJsonException.Builder {
        /**
         * Sets the value of the StringHeader property for this object.
         *
         * @param stringHeader
         *        The new value for the StringHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringHeader(String stringHeader);

        /**
         * Sets the value of the IntegerHeader property for this object.
         *
         * @param integerHeader
         *        The new value for the IntegerHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerHeader(Integer integerHeader);

        /**
         * Sets the value of the LongHeader property for this object.
         *
         * @param longHeader
         *        The new value for the LongHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longHeader(Long longHeader);

        /**
         * Sets the value of the DoubleHeader property for this object.
         *
         * @param doubleHeader
         *        The new value for the DoubleHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleHeader(Double doubleHeader);

        /**
         * Sets the value of the FloatHeader property for this object.
         *
         * @param floatHeader
         *        The new value for the FloatHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatHeader(Float floatHeader);

        /**
         * Sets the value of the TimestampHeader property for this object.
         *
         * @param timestampHeader
         *        The new value for the TimestampHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampHeader(Instant timestampHeader);

        /**
         * Sets the value of the BooleanHeader property for this object.
         *
         * @param booleanHeader
         *        The new value for the BooleanHeader property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanHeader(Boolean booleanHeader);

        /**
         * Sets the value of the PayloadMember property for this object.
         *
         * @param payloadMember
         *        The new value for the PayloadMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(SimpleStruct payloadMember);

        /**
         * Sets the value of the PayloadMember property for this object.
         *
         * This is a convenience that creates an instance of the {@link SimpleStruct.Builder} avoiding the need to
         * create one manually via {@link SimpleStruct#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleStruct.Builder#build()} is called immediately and its
         * result is passed to {@link #payloadMember(SimpleStruct)}.
         * 
         * @param payloadMember
         *        a consumer that will call methods on {@link SimpleStruct.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payloadMember(SimpleStruct)
         */
        default Builder payloadMember(Consumer<SimpleStruct.Builder> payloadMember) {
            return payloadMember(SimpleStruct.builder().applyMutation(payloadMember).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ProtocolRestJsonException.BuilderImpl implements Builder {
        private String stringHeader;

        private Integer integerHeader;

        private Long longHeader;

        private Double doubleHeader;

        private Float floatHeader;

        private Instant timestampHeader;

        private Boolean booleanHeader;

        private SimpleStruct payloadMember;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplicitPayloadAndHeadersException model) {
            super(model);
            stringHeader(model.stringHeader);
            integerHeader(model.integerHeader);
            longHeader(model.longHeader);
            doubleHeader(model.doubleHeader);
            floatHeader(model.floatHeader);
            timestampHeader(model.timestampHeader);
            booleanHeader(model.booleanHeader);
            payloadMember(model.payloadMember);
        }

        public final String getStringHeader() {
            return stringHeader;
        }

        @Override
        public final Builder stringHeader(String stringHeader) {
            this.stringHeader = stringHeader;
            return this;
        }

        public final void setStringHeader(String stringHeader) {
            this.stringHeader = stringHeader;
        }

        public final Integer getIntegerHeader() {
            return integerHeader;
        }

        @Override
        public final Builder integerHeader(Integer integerHeader) {
            this.integerHeader = integerHeader;
            return this;
        }

        public final void setIntegerHeader(Integer integerHeader) {
            this.integerHeader = integerHeader;
        }

        public final Long getLongHeader() {
            return longHeader;
        }

        @Override
        public final Builder longHeader(Long longHeader) {
            this.longHeader = longHeader;
            return this;
        }

        public final void setLongHeader(Long longHeader) {
            this.longHeader = longHeader;
        }

        public final Double getDoubleHeader() {
            return doubleHeader;
        }

        @Override
        public final Builder doubleHeader(Double doubleHeader) {
            this.doubleHeader = doubleHeader;
            return this;
        }

        public final void setDoubleHeader(Double doubleHeader) {
            this.doubleHeader = doubleHeader;
        }

        public final Float getFloatHeader() {
            return floatHeader;
        }

        @Override
        public final Builder floatHeader(Float floatHeader) {
            this.floatHeader = floatHeader;
            return this;
        }

        public final void setFloatHeader(Float floatHeader) {
            this.floatHeader = floatHeader;
        }

        public final Instant getTimestampHeader() {
            return timestampHeader;
        }

        @Override
        public final Builder timestampHeader(Instant timestampHeader) {
            this.timestampHeader = timestampHeader;
            return this;
        }

        public final void setTimestampHeader(Instant timestampHeader) {
            this.timestampHeader = timestampHeader;
        }

        public final Boolean getBooleanHeader() {
            return booleanHeader;
        }

        @Override
        public final Builder booleanHeader(Boolean booleanHeader) {
            this.booleanHeader = booleanHeader;
            return this;
        }

        public final void setBooleanHeader(Boolean booleanHeader) {
            this.booleanHeader = booleanHeader;
        }

        public final SimpleStruct.Builder getPayloadMember() {
            return payloadMember != null ? payloadMember.toBuilder() : null;
        }

        @Override
        public final Builder payloadMember(SimpleStruct payloadMember) {
            this.payloadMember = payloadMember;
            return this;
        }

        public final void setPayloadMember(SimpleStruct.BuilderImpl payloadMember) {
            this.payloadMember = payloadMember != null ? payloadMember.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ExplicitPayloadAndHeadersException build() {
            return new ExplicitPayloadAndHeadersException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
