/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NestedContainersStructure implements SdkPojo, Serializable,
        ToCopyableBuilder<NestedContainersStructure.Builder, NestedContainersStructure> {
    private static final SdkField<List<List<String>>> LIST_OF_LISTS_OF_STRINGS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .getter(getter(NestedContainersStructure::listOfListsOfStrings))
            .setter(setter(Builder::listOfListsOfStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOfListsOfStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<List<SimpleStruct>>> LIST_OF_LISTS_OF_STRUCTS_FIELD = SdkField
            .<List<List<SimpleStruct>>> builder(MarshallingType.LIST)
            .getter(getter(NestedContainersStructure::listOfListsOfStructs))
            .setter(setter(Builder::listOfListsOfStructs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOfListsOfStructs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<SimpleStruct>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<SimpleStruct> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(SimpleStruct::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<List<AllTypesStructure>>> LIST_OF_LISTS_OF_ALL_TYPES_STRUCTS_FIELD = SdkField
            .<List<List<AllTypesStructure>>> builder(MarshallingType.LIST)
            .getter(getter(NestedContainersStructure::listOfListsOfAllTypesStructs))
            .setter(setter(Builder::listOfListsOfAllTypesStructs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOfListsOfAllTypesStructs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<AllTypesStructure>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<AllTypesStructure> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(AllTypesStructure::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<List<List<String>>>> LIST_OF_LIST_OF_LISTS_OF_STRINGS_FIELD = SdkField
            .<List<List<List<String>>>> builder(MarshallingType.LIST)
            .getter(getter(NestedContainersStructure::listOfListOfListsOfStrings))
            .setter(setter(Builder::listOfListOfListsOfStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOfListOfListsOfStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<List<String>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<Map<String, List<List<String>>>> MAP_OF_STRING_TO_LIST_OF_LISTS_OF_STRINGS_FIELD = SdkField
            .<Map<String, List<List<String>>>> builder(MarshallingType.MAP)
            .getter(getter(NestedContainersStructure::mapOfStringToListOfListsOfStrings))
            .setter(setter(Builder::mapOfStringToListOfListsOfStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapOfStringToListOfListsOfStrings")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<List<String>>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<String> STRING_MEMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NestedContainersStructure::stringMember)).setter(setter(Builder::stringMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringMember").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LIST_OF_LISTS_OF_STRINGS_FIELD, LIST_OF_LISTS_OF_STRUCTS_FIELD, LIST_OF_LISTS_OF_ALL_TYPES_STRUCTS_FIELD,
            LIST_OF_LIST_OF_LISTS_OF_STRINGS_FIELD, MAP_OF_STRING_TO_LIST_OF_LISTS_OF_STRINGS_FIELD, STRING_MEMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<List<String>> listOfListsOfStrings;

    private final List<List<SimpleStruct>> listOfListsOfStructs;

    private final List<List<AllTypesStructure>> listOfListsOfAllTypesStructs;

    private final List<List<List<String>>> listOfListOfListsOfStrings;

    private final Map<String, List<List<String>>> mapOfStringToListOfListsOfStrings;

    private final String stringMember;

    private NestedContainersStructure(BuilderImpl builder) {
        this.listOfListsOfStrings = builder.listOfListsOfStrings;
        this.listOfListsOfStructs = builder.listOfListsOfStructs;
        this.listOfListsOfAllTypesStructs = builder.listOfListsOfAllTypesStructs;
        this.listOfListOfListsOfStrings = builder.listOfListOfListsOfStrings;
        this.mapOfStringToListOfListsOfStrings = builder.mapOfStringToListOfListsOfStrings;
        this.stringMember = builder.stringMember;
    }

    /**
     * Returns the value of the ListOfListsOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfListsOfStrings property for this object.
     */
    public List<List<String>> listOfListsOfStrings() {
        return listOfListsOfStrings;
    }

    /**
     * Returns the value of the ListOfListsOfStructs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfListsOfStructs property for this object.
     */
    public List<List<SimpleStruct>> listOfListsOfStructs() {
        return listOfListsOfStructs;
    }

    /**
     * Returns the value of the ListOfListsOfAllTypesStructs property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfListsOfAllTypesStructs property for this object.
     */
    public List<List<AllTypesStructure>> listOfListsOfAllTypesStructs() {
        return listOfListsOfAllTypesStructs;
    }

    /**
     * Returns the value of the ListOfListOfListsOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListOfListOfListsOfStrings property for this object.
     */
    public List<List<List<String>>> listOfListOfListsOfStrings() {
        return listOfListOfListsOfStrings;
    }

    /**
     * Returns the value of the MapOfStringToListOfListsOfStrings property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the MapOfStringToListOfListsOfStrings property for this object.
     */
    public Map<String, List<List<String>>> mapOfStringToListOfListsOfStrings() {
        return mapOfStringToListOfListsOfStrings;
    }

    /**
     * Returns the value of the StringMember property for this object.
     * 
     * @return The value of the StringMember property for this object.
     */
    public String stringMember() {
        return stringMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listOfListsOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(listOfListsOfStructs());
        hashCode = 31 * hashCode + Objects.hashCode(listOfListsOfAllTypesStructs());
        hashCode = 31 * hashCode + Objects.hashCode(listOfListOfListsOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(mapOfStringToListOfListsOfStrings());
        hashCode = 31 * hashCode + Objects.hashCode(stringMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NestedContainersStructure)) {
            return false;
        }
        NestedContainersStructure other = (NestedContainersStructure) obj;
        return Objects.equals(listOfListsOfStrings(), other.listOfListsOfStrings())
                && Objects.equals(listOfListsOfStructs(), other.listOfListsOfStructs())
                && Objects.equals(listOfListsOfAllTypesStructs(), other.listOfListsOfAllTypesStructs())
                && Objects.equals(listOfListOfListsOfStrings(), other.listOfListOfListsOfStrings())
                && Objects.equals(mapOfStringToListOfListsOfStrings(), other.mapOfStringToListOfListsOfStrings())
                && Objects.equals(stringMember(), other.stringMember());
    }

    @Override
    public String toString() {
        return ToString.builder("NestedContainersStructure").add("ListOfListsOfStrings", listOfListsOfStrings())
                .add("ListOfListsOfStructs", listOfListsOfStructs())
                .add("ListOfListsOfAllTypesStructs", listOfListsOfAllTypesStructs())
                .add("ListOfListOfListsOfStrings", listOfListOfListsOfStrings())
                .add("MapOfStringToListOfListsOfStrings", mapOfStringToListOfListsOfStrings())
                .add("StringMember", stringMember()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListOfListsOfStrings":
            return Optional.ofNullable(clazz.cast(listOfListsOfStrings()));
        case "ListOfListsOfStructs":
            return Optional.ofNullable(clazz.cast(listOfListsOfStructs()));
        case "ListOfListsOfAllTypesStructs":
            return Optional.ofNullable(clazz.cast(listOfListsOfAllTypesStructs()));
        case "ListOfListOfListsOfStrings":
            return Optional.ofNullable(clazz.cast(listOfListOfListsOfStrings()));
        case "MapOfStringToListOfListsOfStrings":
            return Optional.ofNullable(clazz.cast(mapOfStringToListOfListsOfStrings()));
        case "StringMember":
            return Optional.ofNullable(clazz.cast(stringMember()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NestedContainersStructure, T> g) {
        return obj -> g.apply((NestedContainersStructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NestedContainersStructure> {
        /**
         * Sets the value of the ListOfListsOfStrings property for this object.
         *
         * @param listOfListsOfStrings
         *        The new value for the ListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfStrings(Collection<? extends Collection<String>> listOfListsOfStrings);

        /**
         * Sets the value of the ListOfListsOfStrings property for this object.
         *
         * @param listOfListsOfStrings
         *        The new value for the ListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfStrings(Collection<String>... listOfListsOfStrings);

        /**
         * Sets the value of the ListOfListsOfStructs property for this object.
         *
         * @param listOfListsOfStructs
         *        The new value for the ListOfListsOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfStructs(Collection<? extends Collection<SimpleStruct>> listOfListsOfStructs);

        /**
         * Sets the value of the ListOfListsOfStructs property for this object.
         *
         * @param listOfListsOfStructs
         *        The new value for the ListOfListsOfStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfStructs(Collection<SimpleStruct>... listOfListsOfStructs);

        /**
         * Sets the value of the ListOfListsOfAllTypesStructs property for this object.
         *
         * @param listOfListsOfAllTypesStructs
         *        The new value for the ListOfListsOfAllTypesStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfAllTypesStructs(Collection<? extends Collection<AllTypesStructure>> listOfListsOfAllTypesStructs);

        /**
         * Sets the value of the ListOfListsOfAllTypesStructs property for this object.
         *
         * @param listOfListsOfAllTypesStructs
         *        The new value for the ListOfListsOfAllTypesStructs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListsOfAllTypesStructs(Collection<AllTypesStructure>... listOfListsOfAllTypesStructs);

        /**
         * Sets the value of the ListOfListOfListsOfStrings property for this object.
         *
         * @param listOfListOfListsOfStrings
         *        The new value for the ListOfListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListOfListsOfStrings(
                Collection<? extends Collection<? extends Collection<String>>> listOfListOfListsOfStrings);

        /**
         * Sets the value of the ListOfListOfListsOfStrings property for this object.
         *
         * @param listOfListOfListsOfStrings
         *        The new value for the ListOfListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOfListOfListsOfStrings(Collection<? extends Collection<String>>... listOfListOfListsOfStrings);

        /**
         * Sets the value of the MapOfStringToListOfListsOfStrings property for this object.
         *
         * @param mapOfStringToListOfListsOfStrings
         *        The new value for the MapOfStringToListOfListsOfStrings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapOfStringToListOfListsOfStrings(
                Map<String, ? extends Collection<? extends Collection<String>>> mapOfStringToListOfListsOfStrings);

        /**
         * Sets the value of the StringMember property for this object.
         *
         * @param stringMember
         *        The new value for the StringMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMember(String stringMember);
    }

    static final class BuilderImpl implements Builder {
        private List<List<String>> listOfListsOfStrings = DefaultSdkAutoConstructList.getInstance();

        private List<List<SimpleStruct>> listOfListsOfStructs = DefaultSdkAutoConstructList.getInstance();

        private List<List<AllTypesStructure>> listOfListsOfAllTypesStructs = DefaultSdkAutoConstructList.getInstance();

        private List<List<List<String>>> listOfListOfListsOfStrings = DefaultSdkAutoConstructList.getInstance();

        private Map<String, List<List<String>>> mapOfStringToListOfListsOfStrings = DefaultSdkAutoConstructMap.getInstance();

        private String stringMember;

        private BuilderImpl() {
        }

        private BuilderImpl(NestedContainersStructure model) {
            listOfListsOfStrings(model.listOfListsOfStrings);
            listOfListsOfStructs(model.listOfListsOfStructs);
            listOfListsOfAllTypesStructs(model.listOfListsOfAllTypesStructs);
            listOfListOfListsOfStrings(model.listOfListOfListsOfStrings);
            mapOfStringToListOfListsOfStrings(model.mapOfStringToListOfListsOfStrings);
            stringMember(model.stringMember);
        }

        public final Collection<? extends Collection<String>> getListOfListsOfStrings() {
            return listOfListsOfStrings;
        }

        @Override
        public final Builder listOfListsOfStrings(Collection<? extends Collection<String>> listOfListsOfStrings) {
            this.listOfListsOfStrings = ListOfListsOfStringsCopier.copy(listOfListsOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfListsOfStrings(Collection<String>... listOfListsOfStrings) {
            listOfListsOfStrings(Arrays.asList(listOfListsOfStrings));
            return this;
        }

        public final void setListOfListsOfStrings(Collection<? extends Collection<String>> listOfListsOfStrings) {
            this.listOfListsOfStrings = ListOfListsOfStringsCopier.copy(listOfListsOfStrings);
        }

        public final Collection<? extends Collection<SimpleStruct>> getListOfListsOfStructs() {
            return listOfListsOfStructs;
        }

        @Override
        public final Builder listOfListsOfStructs(Collection<? extends Collection<SimpleStruct>> listOfListsOfStructs) {
            this.listOfListsOfStructs = ListOfListsOfStructsCopier.copy(listOfListsOfStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfListsOfStructs(Collection<SimpleStruct>... listOfListsOfStructs) {
            listOfListsOfStructs(Arrays.asList(listOfListsOfStructs));
            return this;
        }

        public final void setListOfListsOfStructs(Collection<? extends Collection<SimpleStruct>> listOfListsOfStructs) {
            this.listOfListsOfStructs = ListOfListsOfStructsCopier.copy(listOfListsOfStructs);
        }

        public final Collection<? extends Collection<AllTypesStructure>> getListOfListsOfAllTypesStructs() {
            return listOfListsOfAllTypesStructs;
        }

        @Override
        public final Builder listOfListsOfAllTypesStructs(
                Collection<? extends Collection<AllTypesStructure>> listOfListsOfAllTypesStructs) {
            this.listOfListsOfAllTypesStructs = ListOfListsOfAllTypesStructsCopier.copy(listOfListsOfAllTypesStructs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfListsOfAllTypesStructs(Collection<AllTypesStructure>... listOfListsOfAllTypesStructs) {
            listOfListsOfAllTypesStructs(Arrays.asList(listOfListsOfAllTypesStructs));
            return this;
        }

        public final void setListOfListsOfAllTypesStructs(
                Collection<? extends Collection<AllTypesStructure>> listOfListsOfAllTypesStructs) {
            this.listOfListsOfAllTypesStructs = ListOfListsOfAllTypesStructsCopier.copy(listOfListsOfAllTypesStructs);
        }

        public final Collection<? extends Collection<? extends Collection<String>>> getListOfListOfListsOfStrings() {
            return listOfListOfListsOfStrings;
        }

        @Override
        public final Builder listOfListOfListsOfStrings(
                Collection<? extends Collection<? extends Collection<String>>> listOfListOfListsOfStrings) {
            this.listOfListOfListsOfStrings = ListOfListOfListsOfStringsCopier.copy(listOfListOfListsOfStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listOfListOfListsOfStrings(Collection<? extends Collection<String>>... listOfListOfListsOfStrings) {
            listOfListOfListsOfStrings(Arrays.asList(listOfListOfListsOfStrings));
            return this;
        }

        public final void setListOfListOfListsOfStrings(
                Collection<? extends Collection<? extends Collection<String>>> listOfListOfListsOfStrings) {
            this.listOfListOfListsOfStrings = ListOfListOfListsOfStringsCopier.copy(listOfListOfListsOfStrings);
        }

        public final Map<String, ? extends Collection<? extends Collection<String>>> getMapOfStringToListOfListsOfStrings() {
            return mapOfStringToListOfListsOfStrings;
        }

        @Override
        public final Builder mapOfStringToListOfListsOfStrings(
                Map<String, ? extends Collection<? extends Collection<String>>> mapOfStringToListOfListsOfStrings) {
            this.mapOfStringToListOfListsOfStrings = MapOfStringToListOfListsOfStringsCopier
                    .copy(mapOfStringToListOfListsOfStrings);
            return this;
        }

        public final void setMapOfStringToListOfListsOfStrings(
                Map<String, ? extends Collection<? extends Collection<String>>> mapOfStringToListOfListsOfStrings) {
            this.mapOfStringToListOfListsOfStrings = MapOfStringToListOfListsOfStringsCopier
                    .copy(mapOfStringToListOfListsOfStrings);
        }

        public final String getStringMember() {
            return stringMember;
        }

        @Override
        public final Builder stringMember(String stringMember) {
            this.stringMember = stringMember;
            return this;
        }

        public final void setStringMember(String stringMember) {
            this.stringMember = stringMember;
        }

        @Override
        public NestedContainersStructure build() {
            return new NestedContainersStructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
