/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MembersInHeadersResponse extends ProtocolRestXmlResponse implements
        ToCopyableBuilder<MembersInHeadersResponse.Builder, MembersInHeadersResponse> {
    private final String stringMember;

    private final Boolean booleanMember;

    private final Integer integerMember;

    private final Long longMember;

    private final Float floatMember;

    private final Double doubleMember;

    private final Instant timestampMember;

    private MembersInHeadersResponse(BuilderImpl builder) {
        super(builder);
        this.stringMember = builder.stringMember;
        this.booleanMember = builder.booleanMember;
        this.integerMember = builder.integerMember;
        this.longMember = builder.longMember;
        this.floatMember = builder.floatMember;
        this.doubleMember = builder.doubleMember;
        this.timestampMember = builder.timestampMember;
    }

    /**
     * Returns the value of the StringMember property for this object.
     * 
     * @return The value of the StringMember property for this object.
     */
    public String stringMember() {
        return stringMember;
    }

    /**
     * Returns the value of the BooleanMember property for this object.
     * 
     * @return The value of the BooleanMember property for this object.
     */
    public Boolean booleanMember() {
        return booleanMember;
    }

    /**
     * Returns the value of the IntegerMember property for this object.
     * 
     * @return The value of the IntegerMember property for this object.
     */
    public Integer integerMember() {
        return integerMember;
    }

    /**
     * Returns the value of the LongMember property for this object.
     * 
     * @return The value of the LongMember property for this object.
     */
    public Long longMember() {
        return longMember;
    }

    /**
     * Returns the value of the FloatMember property for this object.
     * 
     * @return The value of the FloatMember property for this object.
     */
    public Float floatMember() {
        return floatMember;
    }

    /**
     * Returns the value of the DoubleMember property for this object.
     * 
     * @return The value of the DoubleMember property for this object.
     */
    public Double doubleMember() {
        return doubleMember;
    }

    /**
     * Returns the value of the TimestampMember property for this object.
     * 
     * @return The value of the TimestampMember property for this object.
     */
    public Instant timestampMember() {
        return timestampMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringMember());
        hashCode = 31 * hashCode + Objects.hashCode(booleanMember());
        hashCode = 31 * hashCode + Objects.hashCode(integerMember());
        hashCode = 31 * hashCode + Objects.hashCode(longMember());
        hashCode = 31 * hashCode + Objects.hashCode(floatMember());
        hashCode = 31 * hashCode + Objects.hashCode(doubleMember());
        hashCode = 31 * hashCode + Objects.hashCode(timestampMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MembersInHeadersResponse)) {
            return false;
        }
        MembersInHeadersResponse other = (MembersInHeadersResponse) obj;
        return Objects.equals(stringMember(), other.stringMember()) && Objects.equals(booleanMember(), other.booleanMember())
                && Objects.equals(integerMember(), other.integerMember()) && Objects.equals(longMember(), other.longMember())
                && Objects.equals(floatMember(), other.floatMember()) && Objects.equals(doubleMember(), other.doubleMember())
                && Objects.equals(timestampMember(), other.timestampMember());
    }

    @Override
    public String toString() {
        return ToString.builder("MembersInHeadersResponse").add("StringMember", stringMember())
                .add("BooleanMember", booleanMember()).add("IntegerMember", integerMember()).add("LongMember", longMember())
                .add("FloatMember", floatMember()).add("DoubleMember", doubleMember()).add("TimestampMember", timestampMember())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringMember":
            return Optional.of(clazz.cast(stringMember()));
        case "BooleanMember":
            return Optional.of(clazz.cast(booleanMember()));
        case "IntegerMember":
            return Optional.of(clazz.cast(integerMember()));
        case "LongMember":
            return Optional.of(clazz.cast(longMember()));
        case "FloatMember":
            return Optional.of(clazz.cast(floatMember()));
        case "DoubleMember":
            return Optional.of(clazz.cast(doubleMember()));
        case "TimestampMember":
            return Optional.of(clazz.cast(timestampMember()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestXmlResponse.Builder, CopyableBuilder<Builder, MembersInHeadersResponse> {
        /**
         * Sets the value of the StringMember property for this object.
         *
         * @param stringMember
         *        The new value for the StringMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMember(String stringMember);

        /**
         * Sets the value of the BooleanMember property for this object.
         *
         * @param booleanMember
         *        The new value for the BooleanMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanMember(Boolean booleanMember);

        /**
         * Sets the value of the IntegerMember property for this object.
         *
         * @param integerMember
         *        The new value for the IntegerMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerMember(Integer integerMember);

        /**
         * Sets the value of the LongMember property for this object.
         *
         * @param longMember
         *        The new value for the LongMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longMember(Long longMember);

        /**
         * Sets the value of the FloatMember property for this object.
         *
         * @param floatMember
         *        The new value for the FloatMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatMember(Float floatMember);

        /**
         * Sets the value of the DoubleMember property for this object.
         *
         * @param doubleMember
         *        The new value for the DoubleMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleMember(Double doubleMember);

        /**
         * Sets the value of the TimestampMember property for this object.
         *
         * @param timestampMember
         *        The new value for the TimestampMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampMember(Instant timestampMember);
    }

    static final class BuilderImpl extends ProtocolRestXmlResponse.BuilderImpl implements Builder {
        private String stringMember;

        private Boolean booleanMember;

        private Integer integerMember;

        private Long longMember;

        private Float floatMember;

        private Double doubleMember;

        private Instant timestampMember;

        private BuilderImpl() {
        }

        private BuilderImpl(MembersInHeadersResponse model) {
            super(model);
            stringMember(model.stringMember);
            booleanMember(model.booleanMember);
            integerMember(model.integerMember);
            longMember(model.longMember);
            floatMember(model.floatMember);
            doubleMember(model.doubleMember);
            timestampMember(model.timestampMember);
        }

        public final String getStringMember() {
            return stringMember;
        }

        @Override
        public final Builder stringMember(String stringMember) {
            this.stringMember = stringMember;
            return this;
        }

        public final void setStringMember(String stringMember) {
            this.stringMember = stringMember;
        }

        public final Boolean getBooleanMember() {
            return booleanMember;
        }

        @Override
        public final Builder booleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
            return this;
        }

        public final void setBooleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
        }

        public final Integer getIntegerMember() {
            return integerMember;
        }

        @Override
        public final Builder integerMember(Integer integerMember) {
            this.integerMember = integerMember;
            return this;
        }

        public final void setIntegerMember(Integer integerMember) {
            this.integerMember = integerMember;
        }

        public final Long getLongMember() {
            return longMember;
        }

        @Override
        public final Builder longMember(Long longMember) {
            this.longMember = longMember;
            return this;
        }

        public final void setLongMember(Long longMember) {
            this.longMember = longMember;
        }

        public final Float getFloatMember() {
            return floatMember;
        }

        @Override
        public final Builder floatMember(Float floatMember) {
            this.floatMember = floatMember;
            return this;
        }

        public final void setFloatMember(Float floatMember) {
            this.floatMember = floatMember;
        }

        public final Double getDoubleMember() {
            return doubleMember;
        }

        @Override
        public final Builder doubleMember(Double doubleMember) {
            this.doubleMember = doubleMember;
            return this;
        }

        public final void setDoubleMember(Double doubleMember) {
            this.doubleMember = doubleMember;
        }

        public final Instant getTimestampMember() {
            return timestampMember;
        }

        @Override
        public final Builder timestampMember(Instant timestampMember) {
            this.timestampMember = timestampMember;
            return this;
        }

        public final void setTimestampMember(Instant timestampMember) {
            this.timestampMember = timestampMember;
        }

        @Override
        public MembersInHeadersResponse build() {
            return new MembersInHeadersResponse(this);
        }
    }
}
