/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.protocolrestjson.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RecursiveStructType JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RecursiveStructTypeUnmarshaller implements Unmarshaller<RecursiveStructType, JsonUnmarshallerContext> {

    public RecursiveStructType unmarshall(JsonUnmarshallerContext context) throws Exception {
        RecursiveStructType.Builder recursiveStructTypeBuilder = RecursiveStructType.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("NoRecurse", targetDepth)) {
                    context.nextToken();
                    recursiveStructTypeBuilder.noRecurse(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RecursiveStruct", targetDepth)) {
                    context.nextToken();
                    recursiveStructTypeBuilder.recursiveStruct(RecursiveStructTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RecursiveList", targetDepth)) {
                    context.nextToken();
                    recursiveStructTypeBuilder.recursiveList(new ListUnmarshaller<RecursiveStructType>(
                            RecursiveStructTypeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("RecursiveMap", targetDepth)) {
                    context.nextToken();
                    recursiveStructTypeBuilder.recursiveMap(new MapUnmarshaller<String, RecursiveStructType>(context
                            .getUnmarshaller(String.class), RecursiveStructTypeUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return recursiveStructTypeBuilder.build();
    }

    private static final RecursiveStructTypeUnmarshaller INSTANCE = new RecursiveStructTypeUnmarshaller();

    public static RecursiveStructTypeUnmarshaller getInstance() {
        return INSTANCE;
    }
}
