/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IdempotentOperationRequest extends ProtocolEc2Request implements
        ToCopyableBuilder<IdempotentOperationRequest.Builder, IdempotentOperationRequest> {
    private final String idempotencyToken;

    private IdempotentOperationRequest(BuilderImpl builder) {
        super(builder);
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * Returns the value of the IdempotencyToken property for this object.
     * 
     * @return The value of the IdempotencyToken property for this object.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdempotentOperationRequest)) {
            return false;
        }
        IdempotentOperationRequest other = (IdempotentOperationRequest) obj;
        return Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    @Override
    public String toString() {
        return ToString.builder("IdempotentOperationRequest").add("IdempotencyToken", idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdempotencyToken":
            return Optional.of(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolEc2Request.Builder, CopyableBuilder<Builder, IdempotentOperationRequest> {
        /**
         * Sets the value of the IdempotencyToken property for this object.
         *
         * @param idempotencyToken
         *        The new value for the IdempotencyToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtocolEc2Request.BuilderImpl implements Builder {
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IdempotentOperationRequest model) {
            super(model);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public IdempotentOperationRequest build() {
            return new IdempotentOperationRequest(this);
        }
    }
}
