/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class MultiLocationOperationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<MultiLocationOperationRequest.Builder, MultiLocationOperationRequest> {
    private final String pathParam;

    private final String queryParamOne;

    private final String queryParamTwo;

    private final String stringHeaderMember;

    private final Date timestampHeaderMember;

    private final PayloadStructType payloadStructParam;

    private MultiLocationOperationRequest(BuilderImpl builder) {
        this.pathParam = builder.pathParam;
        this.queryParamOne = builder.queryParamOne;
        this.queryParamTwo = builder.queryParamTwo;
        this.stringHeaderMember = builder.stringHeaderMember;
        this.timestampHeaderMember = builder.timestampHeaderMember;
        this.payloadStructParam = builder.payloadStructParam;
    }

    /**
     *
     * @return
     */
    public String pathParam() {
        return pathParam;
    }

    /**
     *
     * @return
     */
    public String queryParamOne() {
        return queryParamOne;
    }

    /**
     *
     * @return
     */
    public String queryParamTwo() {
        return queryParamTwo;
    }

    /**
     *
     * @return
     */
    public String stringHeaderMember() {
        return stringHeaderMember;
    }

    /**
     *
     * @return
     */
    public Date timestampHeaderMember() {
        return timestampHeaderMember;
    }

    /**
     *
     * @return
     */
    public PayloadStructType payloadStructParam() {
        return payloadStructParam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((pathParam() == null) ? 0 : pathParam().hashCode());
        hashCode = 31 * hashCode + ((queryParamOne() == null) ? 0 : queryParamOne().hashCode());
        hashCode = 31 * hashCode + ((queryParamTwo() == null) ? 0 : queryParamTwo().hashCode());
        hashCode = 31 * hashCode + ((stringHeaderMember() == null) ? 0 : stringHeaderMember().hashCode());
        hashCode = 31 * hashCode + ((timestampHeaderMember() == null) ? 0 : timestampHeaderMember().hashCode());
        hashCode = 31 * hashCode + ((payloadStructParam() == null) ? 0 : payloadStructParam().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiLocationOperationRequest)) {
            return false;
        }
        MultiLocationOperationRequest other = (MultiLocationOperationRequest) obj;
        if (other.pathParam() == null ^ this.pathParam() == null) {
            return false;
        }
        if (other.pathParam() != null && !other.pathParam().equals(this.pathParam())) {
            return false;
        }
        if (other.queryParamOne() == null ^ this.queryParamOne() == null) {
            return false;
        }
        if (other.queryParamOne() != null && !other.queryParamOne().equals(this.queryParamOne())) {
            return false;
        }
        if (other.queryParamTwo() == null ^ this.queryParamTwo() == null) {
            return false;
        }
        if (other.queryParamTwo() != null && !other.queryParamTwo().equals(this.queryParamTwo())) {
            return false;
        }
        if (other.stringHeaderMember() == null ^ this.stringHeaderMember() == null) {
            return false;
        }
        if (other.stringHeaderMember() != null && !other.stringHeaderMember().equals(this.stringHeaderMember())) {
            return false;
        }
        if (other.timestampHeaderMember() == null ^ this.timestampHeaderMember() == null) {
            return false;
        }
        if (other.timestampHeaderMember() != null && !other.timestampHeaderMember().equals(this.timestampHeaderMember())) {
            return false;
        }
        if (other.payloadStructParam() == null ^ this.payloadStructParam() == null) {
            return false;
        }
        if (other.payloadStructParam() != null && !other.payloadStructParam().equals(this.payloadStructParam())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (pathParam() != null) {
            sb.append("PathParam: ").append(pathParam()).append(",");
        }
        if (queryParamOne() != null) {
            sb.append("QueryParamOne: ").append(queryParamOne()).append(",");
        }
        if (queryParamTwo() != null) {
            sb.append("QueryParamTwo: ").append(queryParamTwo()).append(",");
        }
        if (stringHeaderMember() != null) {
            sb.append("StringHeaderMember: ").append(stringHeaderMember()).append(",");
        }
        if (timestampHeaderMember() != null) {
            sb.append("TimestampHeaderMember: ").append(timestampHeaderMember()).append(",");
        }
        if (payloadStructParam() != null) {
            sb.append("PayloadStructParam: ").append(payloadStructParam()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, MultiLocationOperationRequest> {
        /**
         *
         * @param pathParam
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathParam(String pathParam);

        /**
         *
         * @param queryParamOne
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParamOne(String queryParamOne);

        /**
         *
         * @param queryParamTwo
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParamTwo(String queryParamTwo);

        /**
         *
         * @param stringHeaderMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringHeaderMember(String stringHeaderMember);

        /**
         *
         * @param timestampHeaderMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampHeaderMember(Date timestampHeaderMember);

        /**
         *
         * @param payloadStructParam
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadStructParam(PayloadStructType payloadStructParam);
    }

    private static final class BuilderImpl implements Builder {
        private String pathParam;

        private String queryParamOne;

        private String queryParamTwo;

        private String stringHeaderMember;

        private Date timestampHeaderMember;

        private PayloadStructType payloadStructParam;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiLocationOperationRequest model) {
            setPathParam(model.pathParam);
            setQueryParamOne(model.queryParamOne);
            setQueryParamTwo(model.queryParamTwo);
            setStringHeaderMember(model.stringHeaderMember);
            setTimestampHeaderMember(model.timestampHeaderMember);
            setPayloadStructParam(model.payloadStructParam);
        }

        public final String getPathParam() {
            return pathParam;
        }

        @Override
        public final Builder pathParam(String pathParam) {
            this.pathParam = pathParam;
            return this;
        }

        public final void setPathParam(String pathParam) {
            this.pathParam = pathParam;
        }

        public final String getQueryParamOne() {
            return queryParamOne;
        }

        @Override
        public final Builder queryParamOne(String queryParamOne) {
            this.queryParamOne = queryParamOne;
            return this;
        }

        public final void setQueryParamOne(String queryParamOne) {
            this.queryParamOne = queryParamOne;
        }

        public final String getQueryParamTwo() {
            return queryParamTwo;
        }

        @Override
        public final Builder queryParamTwo(String queryParamTwo) {
            this.queryParamTwo = queryParamTwo;
            return this;
        }

        public final void setQueryParamTwo(String queryParamTwo) {
            this.queryParamTwo = queryParamTwo;
        }

        public final String getStringHeaderMember() {
            return stringHeaderMember;
        }

        @Override
        public final Builder stringHeaderMember(String stringHeaderMember) {
            this.stringHeaderMember = stringHeaderMember;
            return this;
        }

        public final void setStringHeaderMember(String stringHeaderMember) {
            this.stringHeaderMember = stringHeaderMember;
        }

        public final Date getTimestampHeaderMember() {
            return timestampHeaderMember;
        }

        @Override
        public final Builder timestampHeaderMember(Date timestampHeaderMember) {
            this.timestampHeaderMember = StandardMemberCopier.copy(timestampHeaderMember);
            return this;
        }

        public final void setTimestampHeaderMember(Date timestampHeaderMember) {
            this.timestampHeaderMember = StandardMemberCopier.copy(timestampHeaderMember);
        }

        public final PayloadStructType getPayloadStructParam() {
            return payloadStructParam;
        }

        @Override
        public final Builder payloadStructParam(PayloadStructType payloadStructParam) {
            this.payloadStructParam = payloadStructParam;
            return this;
        }

        public final void setPayloadStructParam(PayloadStructType payloadStructParam) {
            this.payloadStructParam = payloadStructParam;
        }

        @Override
        public MultiLocationOperationRequest build() {
            return new MultiLocationOperationRequest(this);
        }
    }
}
