/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.nio.ByteBuffer;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationWithExplicitPayloadBlobRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<OperationWithExplicitPayloadBlobRequest.Builder, OperationWithExplicitPayloadBlobRequest> {
    private final ByteBuffer payloadMember;

    private OperationWithExplicitPayloadBlobRequest(BuilderImpl builder) {
        this.payloadMember = builder.payloadMember;
    }

    /**
     *
     * <p>
     * {@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend
     * using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent
     * {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}
     * . Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the
     * {@code position}.
     * </p>
     * 
     * @return
     */
    public ByteBuffer payloadMember() {
        return payloadMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((payloadMember() == null) ? 0 : payloadMember().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithExplicitPayloadBlobRequest)) {
            return false;
        }
        OperationWithExplicitPayloadBlobRequest other = (OperationWithExplicitPayloadBlobRequest) obj;
        if (other.payloadMember() == null ^ this.payloadMember() == null) {
            return false;
        }
        if (other.payloadMember() != null && !other.payloadMember().equals(this.payloadMember())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (payloadMember() != null) {
            sb.append("PayloadMember: ").append(payloadMember()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, OperationWithExplicitPayloadBlobRequest> {
        /**
         *
         * @param payloadMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(ByteBuffer payloadMember);
    }

    private static final class BuilderImpl implements Builder {
        private ByteBuffer payloadMember;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithExplicitPayloadBlobRequest model) {
            setPayloadMember(model.payloadMember);
        }

        public final ByteBuffer getPayloadMember() {
            return payloadMember;
        }

        @Override
        public final Builder payloadMember(ByteBuffer payloadMember) {
            this.payloadMember = StandardMemberCopier.copy(payloadMember);
            return this;
        }

        public final void setPayloadMember(ByteBuffer payloadMember) {
            this.payloadMember = StandardMemberCopier.copy(payloadMember);
        }

        @Override
        public OperationWithExplicitPayloadBlobRequest build() {
            return new OperationWithExplicitPayloadBlobRequest(this);
        }
    }
}
