/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IdempotentOperationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<IdempotentOperationRequest.Builder, IdempotentOperationRequest> {
    private final String pathIdempotentToken;

    private final String queryIdempotentToken;

    private final String headerIdempotentToken;

    private IdempotentOperationRequest(BuilderImpl builder) {
        this.pathIdempotentToken = builder.pathIdempotentToken;
        this.queryIdempotentToken = builder.queryIdempotentToken;
        this.headerIdempotentToken = builder.headerIdempotentToken;
    }

    /**
     *
     * @return
     */
    public String pathIdempotentToken() {
        return pathIdempotentToken;
    }

    /**
     *
     * @return
     */
    public String queryIdempotentToken() {
        return queryIdempotentToken;
    }

    /**
     *
     * @return
     */
    public String headerIdempotentToken() {
        return headerIdempotentToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((pathIdempotentToken() == null) ? 0 : pathIdempotentToken().hashCode());
        hashCode = 31 * hashCode + ((queryIdempotentToken() == null) ? 0 : queryIdempotentToken().hashCode());
        hashCode = 31 * hashCode + ((headerIdempotentToken() == null) ? 0 : headerIdempotentToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdempotentOperationRequest)) {
            return false;
        }
        IdempotentOperationRequest other = (IdempotentOperationRequest) obj;
        if (other.pathIdempotentToken() == null ^ this.pathIdempotentToken() == null) {
            return false;
        }
        if (other.pathIdempotentToken() != null && !other.pathIdempotentToken().equals(this.pathIdempotentToken())) {
            return false;
        }
        if (other.queryIdempotentToken() == null ^ this.queryIdempotentToken() == null) {
            return false;
        }
        if (other.queryIdempotentToken() != null && !other.queryIdempotentToken().equals(this.queryIdempotentToken())) {
            return false;
        }
        if (other.headerIdempotentToken() == null ^ this.headerIdempotentToken() == null) {
            return false;
        }
        if (other.headerIdempotentToken() != null && !other.headerIdempotentToken().equals(this.headerIdempotentToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (pathIdempotentToken() != null) {
            sb.append("PathIdempotentToken: ").append(pathIdempotentToken()).append(",");
        }
        if (queryIdempotentToken() != null) {
            sb.append("QueryIdempotentToken: ").append(queryIdempotentToken()).append(",");
        }
        if (headerIdempotentToken() != null) {
            sb.append("HeaderIdempotentToken: ").append(headerIdempotentToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IdempotentOperationRequest> {
        /**
         *
         * @param pathIdempotentToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathIdempotentToken(String pathIdempotentToken);

        /**
         *
         * @param queryIdempotentToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryIdempotentToken(String queryIdempotentToken);

        /**
         *
         * @param headerIdempotentToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerIdempotentToken(String headerIdempotentToken);
    }

    private static final class BuilderImpl implements Builder {
        private String pathIdempotentToken;

        private String queryIdempotentToken;

        private String headerIdempotentToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IdempotentOperationRequest model) {
            setPathIdempotentToken(model.pathIdempotentToken);
            setQueryIdempotentToken(model.queryIdempotentToken);
            setHeaderIdempotentToken(model.headerIdempotentToken);
        }

        public final String getPathIdempotentToken() {
            return pathIdempotentToken;
        }

        @Override
        public final Builder pathIdempotentToken(String pathIdempotentToken) {
            this.pathIdempotentToken = pathIdempotentToken;
            return this;
        }

        public final void setPathIdempotentToken(String pathIdempotentToken) {
            this.pathIdempotentToken = pathIdempotentToken;
        }

        public final String getQueryIdempotentToken() {
            return queryIdempotentToken;
        }

        @Override
        public final Builder queryIdempotentToken(String queryIdempotentToken) {
            this.queryIdempotentToken = queryIdempotentToken;
            return this;
        }

        public final void setQueryIdempotentToken(String queryIdempotentToken) {
            this.queryIdempotentToken = queryIdempotentToken;
        }

        public final String getHeaderIdempotentToken() {
            return headerIdempotentToken;
        }

        @Override
        public final Builder headerIdempotentToken(String headerIdempotentToken) {
            this.headerIdempotentToken = headerIdempotentToken;
            return this;
        }

        public final void setHeaderIdempotentToken(String headerIdempotentToken) {
            this.headerIdempotentToken = headerIdempotentToken;
        }

        @Override
        public IdempotentOperationRequest build() {
            return new IdempotentOperationRequest(this);
        }
    }
}
