/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * MultiLocationOperationRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class MultiLocationOperationRequestModelMarshaller {

    private static final MarshallingInfo<StructuredPojo> PAYLOADMEMBER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).build();
    private static final MarshallingInfo<String> HEADERMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-apig-header-string").build();
    private static final MarshallingInfo<String> QUERYMEMBERONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("QueryMemberOne").build();
    private static final MarshallingInfo<String> QUERYMEMBERTWO_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("QueryMemberTwo").build();
    private static final MarshallingInfo<String> PATHMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("PathParam").build();

    private static final MultiLocationOperationRequestModelMarshaller instance = new MultiLocationOperationRequestModelMarshaller();

    public static MultiLocationOperationRequestModelMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MultiLocationOperationRequest multiLocationOperationRequest, ProtocolMarshaller protocolMarshaller) {

        if (multiLocationOperationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(multiLocationOperationRequest.payloadMember(), PAYLOADMEMBER_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.headerMember(), HEADERMEMBER_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.queryMemberOne(), QUERYMEMBERONE_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.queryMemberTwo(), QUERYMEMBERTWO_BINDING);
            protocolMarshaller.marshall(multiLocationOperationRequest.pathMember(), PATHMEMBER_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
