/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.junit.Assert;
import org.w3c.dom.Document;
import software.amazon.awssdk.core.util.StringInputStream;

public final class XmlAsserts {
    private static final DocumentBuilder DOCUMENT_BUILDER = XmlAsserts.getDocumentBuilder();

    private XmlAsserts() {
    }

    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertXmlEquals(String expectedXml, String actualXml) {
        try {
            XmlAsserts.doAssertXmlEquals(expectedXml, actualXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void doAssertXmlEquals(String expectedXml, String actualXml) throws Exception {
        Diff diff = new Diff(expectedXml, actualXml);
        diff.overrideElementQualifier((ElementQualifier)new RecursiveElementNameAndTextQualifier());
        if (!diff.similar()) {
            Assert.fail((String)String.format("\nExpected the following XML\n" + XmlAsserts.formatXml(expectedXml) + "\nbut actual XML was\n\n" + XmlAsserts.formatXml(actualXml), new Object[0]));
        }
    }

    private static String formatXml(String xmlDocumentString) throws Exception {
        return XmlAsserts.formatXml(DOCUMENT_BUILDER.parse((InputStream)new StringInputStream(xmlDocumentString)));
    }

    private static String formatXml(Document xmlDocument) throws Exception {
        Transformer transformer = XmlAsserts.transformerFactory().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(xmlDocument);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    private static TransformerFactory transformerFactory() throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://javax.xml.XMLConstants/property/accessExternalDTD", false);
        return factory;
    }
}

