/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import software.amazon.awssdk.protocol.asserts.marshalling.MarshallingAssertion;

public class HeadersAssertion
extends MarshallingAssertion {
    private Map<String, String> contains;
    private List<String> doesNotContain;

    public void setContains(Map<String, String> contains) {
        this.contains = contains;
    }

    public void setDoesNotContain(List<String> doesNotContain) {
        this.doesNotContain = doesNotContain;
    }

    @Override
    protected void doAssert(LoggedRequest actual) throws Exception {
        if (this.contains != null) {
            this.assertHeadersContains(actual.getHeaders());
        }
        if (this.doesNotContain != null) {
            this.assertDoesNotContainHeaders(actual.getHeaders());
        }
    }

    private void assertHeadersContains(HttpHeaders actual) {
        this.contains.entrySet().stream().forEach(e -> Assert.assertEquals(e.getValue(), (Object)actual.getHeader((String)e.getKey()).firstValue()));
    }

    private void assertDoesNotContainHeaders(HttpHeaders actual) {
        this.doesNotContain.stream().forEach(headerName -> Assert.assertFalse((String)String.format("Header '%s' was expected to be absent", headerName), (boolean)actual.getHeader(headerName).isPresent()));
    }
}

