/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.asserts.marshalling;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocol.asserts.marshalling.CompositeMarshallingAssertion;
import software.amazon.awssdk.protocol.asserts.marshalling.HeadersAssertion;
import software.amazon.awssdk.protocol.asserts.marshalling.HttpMethodAssertion;
import software.amazon.awssdk.protocol.asserts.marshalling.QueryParamsAssertion;
import software.amazon.awssdk.protocol.asserts.marshalling.RequestBodyAssertion;
import software.amazon.awssdk.protocol.asserts.marshalling.UriAssertion;
import software.amazon.awssdk.protocol.model.SdkHttpMethodDeserializer;

public class SerializedAs
extends CompositeMarshallingAssertion {
    public void setBody(RequestBodyAssertion body) {
        this.addAssertion(body);
    }

    public void setHeaders(HeadersAssertion headers) {
        this.addAssertion(headers);
    }

    public void setUri(String uri) {
        this.addAssertion(new UriAssertion(uri));
    }

    @JsonDeserialize(using=SdkHttpMethodDeserializer.class)
    public void setMethod(SdkHttpMethod method) {
        this.addAssertion(new HttpMethodAssertion(method));
    }

    public void setParams(QueryParamsAssertion params) {
        this.addAssertion(params);
    }
}

